/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.CompiledBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.BaseInputFieldWithKeySupport;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.InputFieldDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@TemplateControl(tagName="fh-input-timestamp")
@DesignerControl(defaultWidth=3)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Component responsible for displaying field, where use can set date and time.", icon="fa fa-clock")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@OverridenPropertyAnnotations(property="modelBinding", designerXmlProperty={@DesignerXMLProperty(allowedTypes={Date.class, LocalDateTime.class}, commonUse=true, previewValueProvider=InputFieldDesignerPreviewProvider.class, priority=80, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)})
public class InputTimestamp
extends BaseInputFieldWithKeySupport {
    private static final String DEFAULT_DATE_TIME_FORMATTER = "defaultDateTimeFormatter";
    private static final String OPTIONAL_LOCAL_DATE_TIME_FORMATTER = "optionalLocalDateTimeFormatter";
    @XMLProperty
    @DocumentedComponentAttribute(value="Date format, may be one of following described here: http://momentjs.com/docs/#/displaying/format/")
    private String format;

    public InputTimestamp(Form form) {
        super(form);
    }

    @Override
    public InputTimestamp createNewSameComponent() {
        return new InputTimestamp(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        InputTimestamp clone = (InputTimestamp)baseClone;
        clone.setFormat(this.getFormat());
    }

    @Override
    protected void processCoversionException(FhBindingException cfe) {
    }

    @JsonIgnore
    public Optional<String> getOptionalFormatter() {
        ModelBinding m = this.getModelBinding();
        BindingResult b = m.getBindingResult();
        if (m instanceof CompiledBinding && ((CompiledBinding)m).getTargetType() == Date.class || b.getTargetType() == Date.class) {
            return Optional.of(DEFAULT_DATE_TIME_FORMATTER);
        }
        return Optional.of(OPTIONAL_LOCAL_DATE_TIME_FORMATTER);
    }

    protected boolean areModelValuesTheSame(Object firstValue, Object secondValue) {
        return !this.isValidConversion() || super.areValuesTheSame(firstValue, secondValue);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

