/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.docs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import pl.fhframework.ReflectionUtils;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DocumentedAttributesHolder;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.designer.ComponentElement;
import pl.fhframework.core.designer.DocumentedAttribute;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.model.forms.attributes.AttributeHolder;
import pl.fhframework.model.forms.docs.DocumentationPathParams;
import pl.fhframework.model.forms.docs.model.FormComponentDocumentationHolder;
import pl.fhframework.model.forms.docs.model.FormElementCategory;

@Service
public class FormComponentsDocumentationService {
    private static final String FORM_CLASS_PATH = "pl.fhframework.docs.forms.component.%s%sForm";
    private static final String ELEMENT_CLASS_PATH = "pl.fhframework.docs.forms.component.%smodel.%sElement";
    private static final String UC_CLASS_PATH = "pl.fhframework.docs.uc.%s%sUC";
    private static final String DOCUMENTED_COMPONENTS_PACKAGE = "pl";
    private static final String GIS2D_PACKAGE = "pl.fhframework.gis2d";
    private static final String FH_BASIC_COMPONENTS_PACKAGE = "pl.fhframework.model";
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private MessageService messageService;

    public FormComponentDocumentationHolder findDocumentedBasicComponentsForPredicate(Boolean canBeDesigned) throws ClassNotFoundException {
        FormComponentDocumentationHolder form = new FormComponentDocumentationHolder();
        DocumentationPathParams pathParams = new DocumentationPathParams(FORM_CLASS_PATH, ELEMENT_CLASS_PATH, FH_BASIC_COMPONENTS_PACKAGE, UC_CLASS_PATH);
        Map<String, FormElementCategory> documentationElementsMap = this.collectDocumentedFormComponents(FormComponentsDocumentationService.isInPackage(pathParams.getComponentsPackage()), canBeDesigned, pathParams);
        ArrayList<FormElementCategory> componentCategories = new ArrayList<FormElementCategory>(documentationElementsMap.values());
        componentCategories.forEach(c -> c.setName(this.messageService.getBundle("fhCoreMessageSource").getEnumMessage((Enum)c.getCategory())));
        componentCategories.sort(Comparator.comparing(o -> o.getCategory().ordinal()));
        form.setFormElements(componentCategories);
        return form;
    }

    public FormComponentDocumentationHolder findDocumentedMap2dComponentsForPredicate(Predicate<? super Class<?>> predicate, DocumentationPathParams pathParams) throws ClassNotFoundException {
        return this.findDocumentedMap2dComponentsForPredicate(predicate, pathParams, "maps");
    }

    public FormComponentDocumentationHolder findDocumentedMap2dComponentsForPredicate(Predicate<? super Class<?>> predicate, DocumentationPathParams pathParams, String category) throws ClassNotFoundException {
        FormComponentDocumentationHolder form = new FormComponentDocumentationHolder();
        Map<String, FormElementCategory> documentationElementsMap = this.collectDocumentedFormComponents(predicate, null, pathParams);
        form.setMap2dElements(documentationElementsMap.get("").getComponents());
        return form;
    }

    public Map<String, FormElementCategory> collectDocumentedFormComponents(Predicate<? super Class<?>> predicate, Boolean canBeDesigned, DocumentationPathParams pathParams) throws ClassNotFoundException {
        TreeMap<String, FormElementCategory> componentDocumentation = new TreeMap<String, FormElementCategory>();
        List<Class<?>> documentedClasses = this.findDocumentedClasses(predicate);
        for (Class<?> clazz : documentedClasses) {
            Control formElementAnnotation = clazz.getAnnotation(Control.class);
            if (canBeDesigned != null && (formElementAnnotation == null || !canBeDesigned.equals(formElementAnnotation.canBeDesigned()))) continue;
            DocumentedComponent classAnnotation = clazz.getAnnotation(DocumentedComponent.class);
            String[] attributeExcludes = classAnnotation.ignoreFields();
            String formComponentSimpleName = clazz.getSimpleName();
            DocumentedComponent.Category category = classAnnotation.category();
            try {
                Class<?> formDocumentationComponentClassName = Class.forName(String.format(pathParams.getModelClassPath(), "", formComponentSimpleName));
                ComponentElement element = (ComponentElement)this.appContext.getBean(formDocumentationComponentClassName);
                element.setForm(Class.forName(String.format(pathParams.getFormClassPath(), "", formComponentSimpleName)));
                element.setUseCase(ReflectionUtils.tryGetClassForName((String)String.format(pathParams.getUcClassPath(), "", formComponentSimpleName)));
                element.setDescription(classAnnotation.value());
                element.setComponentName(formComponentSimpleName);
                element.setClazz(clazz);
                element.setCategory(category);
                element.setIcon(classAnnotation.icon());
                this.collectDocumentedAttributes(clazz, element, Arrays.asList(attributeExcludes));
                String categoryName = category.toString();
                if (componentDocumentation.containsKey(categoryName)) {
                    ((FormElementCategory)componentDocumentation.get(categoryName)).getComponents().add(element);
                    continue;
                }
                FormElementCategory formElementCategory = new FormElementCategory(categoryName, category, new ArrayList<ComponentElement>());
                formElementCategory.getComponents().add(element);
                componentDocumentation.put(categoryName, formElementCategory);
            }
            catch (ClassNotFoundException ex) {
                FhLogger.warn((String)"There is no documentation for component", (Throwable)ex);
            }
        }
        return componentDocumentation;
    }

    private List<Class<?>> findDocumentedClasses(Predicate<? super Class<?>> predicate) {
        List annotatedClasses = ReflectionUtils.getAnnotatedClasses((String)DOCUMENTED_COMPONENTS_PACKAGE, DocumentedComponent.class);
        if (predicate == null) {
            return annotatedClasses;
        }
        List<Class<?>> fhStandardControls = this.filterStandardControlsDocumentation(annotatedClasses);
        return new ArrayList(fhStandardControls);
    }

    private List<Class<?>> filterStandardControlsDocumentation(List<Class<?>> annotatedClasses) {
        ArrayList fhStandardControls = new ArrayList();
        for (Class<?> annotatedClass : annotatedClasses) {
            DocumentedComponent documentedComponentAnnotation = annotatedClass.getAnnotation(DocumentedComponent.class);
            if (!documentedComponentAnnotation.documentationExample()) continue;
            fhStandardControls.add(annotatedClass);
        }
        return fhStandardControls;
    }

    private void collectDocumentedAttributes(Class<?> clazz, ComponentElement element, List<String> attributeExcludes) {
        ArrayList<DocumentedAttribute> documentedAttributes = new ArrayList<DocumentedAttribute>();
        while (clazz != null) {
            documentedAttributes.addAll(this.collectDocumentedAttributes(clazz, attributeExcludes));
            clazz = clazz.getSuperclass();
        }
        Collections.sort(documentedAttributes, (attributeDoc1, attributeDoc2) -> attributeDoc1.getName().compareTo(attributeDoc2.getName()));
        element.setAttributes(documentedAttributes);
    }

    private List<DocumentedAttribute> collectDocumentedAttributes(Class<?> clazz, List<String> attributeExcludes) {
        ArrayList<DocumentedAttribute> documentedAttributes = new ArrayList<DocumentedAttribute>();
        List holderFields = ReflectionUtils.getFields(clazz, DocumentedAttributesHolder.class);
        for (Field field : holderFields) {
            Class[] attributeClasses;
            if (!ClassUtils.isAssignable(AttributeHolder.class, field.getType())) continue;
            DocumentedAttributesHolder documentationAttributesHolder = field.getAnnotation(DocumentedAttributesHolder.class);
            for (Class attributeClass : attributeClasses = documentationAttributesHolder.attributeClasses()) {
                DocumentedAttribute documentedAttribute = new DocumentedAttribute();
                XMLProperty xmlPropertyAnnotation = attributeClass.getAnnotation(XMLProperty.class);
                String xmlAttributeValue = xmlPropertyAnnotation.value();
                if (attributeExcludes.contains(xmlAttributeValue)) continue;
                DocumentedComponentAttribute documentedComponentAttributeAnnotation = attributeClass.getAnnotation(DocumentedComponentAttribute.class);
                documentedAttribute.setType(documentedComponentAttributeAnnotation.type().getSimpleName());
                documentedAttribute.setName(xmlAttributeValue);
                documentedAttribute.setDescription(documentedComponentAttributeAnnotation.value());
                documentedAttribute.setDefaultValue(documentedComponentAttributeAnnotation.defaultValue());
                documentedAttribute.setBoundable(documentedComponentAttributeAnnotation.boundable());
                documentedAttributes.add(documentedAttribute);
            }
        }
        List fields = ReflectionUtils.getFields(clazz, DocumentedComponentAttribute.class);
        for (Field f : fields) {
            DocumentedAttribute documentedAttribute = this.createDocumentedAttribute(clazz, attributeExcludes, f);
            if (documentedAttribute == null) continue;
            documentedAttributes.add(documentedAttribute);
        }
        return documentedAttributes;
    }

    private static Predicate<? super Class<?>> isInPackage(String packageName) {
        return clazz -> clazz.getName().contains(packageName);
    }

    private static Predicate<? super Class<?>> isNotGis2d() {
        return clazz -> !clazz.getName().contains(GIS2D_PACKAGE);
    }

    private DocumentedAttribute createDocumentedAttribute(Class<?> clazz, List<String> attributeExcludes, Field f) {
        String fieldName;
        DocumentedAttribute documentedAttribute = new DocumentedAttribute();
        if (documentedAttribute.getType() == null) {
            documentedAttribute.setType(f.getType().getSimpleName());
        }
        if (attributeExcludes.contains(fieldName = f.getName())) {
            return null;
        }
        XMLProperty xmlPropertyAnnotation = f.getAnnotation(XMLProperty.class);
        String xmlAttributeValue = xmlPropertyAnnotation.value();
        if (xmlPropertyAnnotation != null && !StringUtils.isEmpty((Object)xmlPropertyAnnotation.value())) {
            documentedAttribute.setName(xmlAttributeValue);
        } else {
            documentedAttribute.setName(fieldName);
        }
        DocumentedComponentAttribute attributeAnnotation = f.getAnnotation(DocumentedComponentAttribute.class);
        documentedAttribute.setDescription(attributeAnnotation.value());
        documentedAttribute.setDefaultValue(attributeAnnotation.defaultValue());
        documentedAttribute.setBoundable(attributeAnnotation.boundable());
        if (attributeAnnotation.type() != DocumentedComponentAttribute.EMPTY.class) {
            documentedAttribute.setType(attributeAnnotation.type().getSimpleName());
        }
        if (attributeAnnotation.canReadNested()) {
            Class<?> nestedClass = f.getType();
            if (ModelBinding.class.isAssignableFrom(nestedClass) && ReflectionUtils.getGenericTypeInFieldType((Field)f, (int)0) != null) {
                Class modelBindingClass = ReflectionUtils.getGenericTypeInFieldType((Field)f, (int)0);
                org.springframework.util.ReflectionUtils.doWithFields((Class)modelBindingClass, nestedField -> documentedAttribute.getNestedAttributes().add(this.createDocumentedAttribute(modelBindingClass, attributeExcludes, nestedField)), field -> field.isAnnotationPresent(DocumentedComponentAttribute.class));
            } else {
                org.springframework.util.ReflectionUtils.doWithFields(nestedClass, nestedField -> documentedAttribute.getNestedAttributes().add(this.createDocumentedAttribute(nestedClass, attributeExcludes, nestedField)), field -> field.isAnnotationPresent(DocumentedComponentAttribute.class));
            }
        }
        return documentedAttribute;
    }
}

