/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.events.IEventSource;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Accordion;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponentWithHeadingHierarchy;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.SplitContainer;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.IDesignerEventListener;

@OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(readOnlyInDesigner=true)}, property="hintType")
@TemplateControl(tagName="fh-panel-group")
@Control(parents={Accordion.class, PanelGroup.class, Group.class, SplitContainer.class, Repeater.class, Column.class, Tab.class, Row.class, Form.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.ARRANGEMENT, documentationExample=true, value="PanelGroup component is responsible for the grouping of sub-elements with optional header and collapsing", icon="fa fa-object-group")
public class PanelGroup
extends GroupingComponentWithHeadingHierarchy<Component>
implements Boundable,
IChangeableByClient,
IEventSource,
IHasBoundableLabel,
IDesignerEventListener {
    private static final String COLLAPSED_ATTR = "collapsed";
    public static final String ON_TOGGLE = "onToggle";
    public static final String LABEL_ATTR = "label";
    public static final String BORDER_VISIBLE_ATTR = "borderVisible";
    public static final String ICON_OPENED = "iconOpened";
    public static final String ICON_CLOSED = "iconClosed";
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - FH Markup Language.")
    private ModelBinding<String> labelModelBinding;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Defines if group can be collapsed or expanded. False by default.")
    private boolean collapsible = false;
    @XMLProperty(value="borderVisible")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=76)
    @DocumentedComponentAttribute(defaultValue="false", value="Defines if group should have border. False by default.")
    private boolean borderVisible = false;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="Name of event which will be invoked after cliking collapse group button. Over it it also defines if group can be collapsed or expanded. Empty by default (not collapsible).")
    private ActionBinding onToggle;
    private boolean collapsed = false;
    @JsonIgnore
    @XMLProperty(value="collapsed", defaultValue="false")
    @DocumentedComponentAttribute(defaultValue="false", boundable=true, value="Contains a state for collapsible group, if the group is currently collapsed or expanded. Depends on attribute: collapsible, if it's not set then binding will not be resolved. False by default.")
    private ModelBinding modelBindingForState = new StaticBinding((Object)false);
    private String iconOpened;
    @JsonIgnore
    @XMLProperty(value="iconOpened", defaultValue="fa-arrow-down")
    @DocumentedComponentAttribute(defaultValue="fa-arrow-down", boundable=true, value="Icon for panel that is open. Please refer to http://fontawesome.io/icons/ for all available icons.")
    @DesignerXMLProperty(priority=84, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    private ModelBinding<String> iconOpenedBinding;
    private String iconClosed;
    @JsonIgnore
    @XMLProperty(value="iconClosed", defaultValue="fa-arrow-up")
    @DocumentedComponentAttribute(defaultValue="fa-arrow-up", boundable=true, value="Icon for closed panel. Please refer to http://fontawesome.io/icons/ for all available icons.")
    @DesignerXMLProperty(priority=84, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    private ModelBinding<String> iconClosedBinding;

    public PanelGroup(Form form) {
        super(form);
    }

    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.resolveBindingForLabel(elementChanges);
        if (this.isCollapsible()) {
            this.resolveBindingForCollapsed(elementChanges);
        }
        if (this.iconOpenedBinding != null) {
            this.iconOpened = this.iconOpenedBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.iconOpened, ICON_OPENED);
        }
        if (this.iconClosedBinding != null) {
            this.iconClosed = this.iconClosedBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.iconClosed, ICON_CLOSED);
        }
        return elementChanges;
    }

    private void resolveBindingForCollapsed(ElementChanges elementChanges) {
        boolean newValue;
        BindingResult bindingResultForCollapsed;
        if (this.modelBindingForState != null && (bindingResultForCollapsed = this.modelBindingForState.getBindingResult()) != null && this.collapsed != (newValue = Boolean.valueOf(this.convertBindingValueToString(bindingResultForCollapsed)).booleanValue())) {
            this.refreshView();
            this.collapsed = newValue;
            elementChanges.addChange(COLLAPSED_ATTR, (Object)this.collapsed);
        }
    }

    private void resolveBindingForLabel(ElementChanges elementChanges) {
        if (this.labelModelBinding != null) {
            this.label = this.labelModelBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.label, LABEL_ATTR);
        }
    }

    public void updateModel(ValueChange valueChange) {
        if (this.modelBindingForState != null && valueChange.hasMainValueChanged()) {
            this.updateBinding(valueChange, this.modelBindingForState, this.modelBindingForState.getBindingExpression());
        }
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_TOGGLE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onToggle);
        }
        return super.getEventHandler(eventData);
    }

    public void setOnToggle(ActionBinding onToggle) {
        this.onToggle = onToggle;
    }

    public IActionCallbackContext setOnToggle(IActionCallback onToggle) {
        return CallbackActionBinding.createAndSet((IActionCallback)onToggle, this::setOnToggle);
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        this.addSubcomponent((Component)this.createNewRow());
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.addSubcomponent((Component)this.createNewRow());
    }

    public Row createNewRow() {
        Row row = new Row(this.getForm());
        row.setGroupingParentComponent((IGroupingComponent)this);
        row.init();
        return row;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding<String> getLabelModelBinding() {
        return this.labelModelBinding;
    }

    public void setLabelModelBinding(ModelBinding<String> labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
    }

    public ActionBinding getOnToggle() {
        return this.onToggle;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public ModelBinding getModelBindingForState() {
        return this.modelBindingForState;
    }

    public void setModelBindingForState(ModelBinding modelBindingForState) {
        this.modelBindingForState = modelBindingForState;
    }

    public String getIconOpened() {
        return this.iconOpened;
    }

    public ModelBinding<String> getIconOpenedBinding() {
        return this.iconOpenedBinding;
    }

    public void setIconOpenedBinding(ModelBinding<String> iconOpenedBinding) {
        this.iconOpenedBinding = iconOpenedBinding;
    }

    public String getIconClosed() {
        return this.iconClosed;
    }

    public ModelBinding<String> getIconClosedBinding() {
        return this.iconClosedBinding;
    }

    public void setIconClosedBinding(ModelBinding<String> iconClosedBinding) {
        this.iconClosedBinding = iconClosedBinding;
    }
}

