/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.designer;

import java.lang.reflect.Field;
import org.springframework.beans.factory.annotation.Autowired;
import pl.fhframework.binding.DesignerModelBinding;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.core.rules.service.RulesService;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.forms.Combo;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.InputText;
import pl.fhframework.model.forms.designer.I18nAwareDesignerPreviewProvider;

public class InputFieldDesignerPreviewProvider
extends I18nAwareDesignerPreviewProvider {
    @Autowired
    private RulesService rulesService;
    @Autowired
    private MessageService messageService;

    public InputFieldDesignerPreviewProvider() {
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.rulesService});
    }

    public Object getPreviewValue(Component component, Field field, DesignerModelBinding<?> modelBinding, String bindingExpression, String bindingStaticValue, String propertyDefaultValue) {
        if (bindingStaticValue != null) {
            return bindingStaticValue;
        }
        if (component instanceof InputText || component instanceof Combo) {
            String shortExpression = this.rulesService.convertToShortNames(bindingExpression);
            if (component.getForm().isDesignMode()) {
                return shortExpression;
            }
            return this.getI18nBindingValue(this.messageService, component.getForm(), modelBinding).orElse(shortExpression);
        }
        return null;
    }
}

