/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.validation.ConstraintViolation;
import pl.fhframework.validation.Validator;

public abstract class AbstractRequiredFormElementValidator<T>
implements Validator<T> {
    @Autowired
    private MessageService messageService;

    public abstract boolean canProcessValidation(T var1);

    public abstract boolean isNotValid(T var1);

    public List<ConstraintViolation<T>> validate(T formElement) {
        ArrayList<ConstraintViolation<T>> violations = new ArrayList<ConstraintViolation<T>>();
        if (!this.canProcessValidation(formElement)) {
            return violations;
        }
        if (this.isNotValid(formElement)) {
            this.addConstraintViolation(violations, formElement, this.messageService.getAllBundles().getMessage("fh.core.validation.field.is_required"));
        }
        return violations;
    }
}

