/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.widgets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedAttributesHolder;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Accordion;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SplitContainer;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.attributes.AttributeHolder;
import pl.fhframework.model.forms.attributes.AttributeHolderBuilder;
import pl.fhframework.model.forms.attributes.widget.SizeXAttribute;
import pl.fhframework.model.forms.attributes.widget.SizeYAttribute;
import pl.fhframework.model.forms.attributes.widget.XPosAttribute;
import pl.fhframework.model.forms.attributes.widget.YPosAttribute;

@Control(parents={Accordion.class, PanelGroup.class, Group.class, SplitContainer.class, Row.class, Form.class, Tab.class, Repeater.class}, invalidParents={Table.class})
@DocumentedComponent(documentationExample=true, value="Widget component responsible for the grouping of sub-elements", icon="fa fa-qrcode")
public class Widget
extends PanelGroup {
    private static final String DESCRIPTION_ATTR = "description";
    @JsonUnwrapped
    @DocumentedAttributesHolder(attributeClasses={SizeXAttribute.class, SizeYAttribute.class, XPosAttribute.class, YPosAttribute.class})
    private AttributeHolder attributeHolder;
    @XMLProperty
    @JsonIgnore
    private String description = "";
    private boolean markAsDeleted;
    @JsonIgnore
    @XMLProperty(value="sizeX")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    private ModelBinding sizeXBinding;
    @JsonIgnore
    @XMLProperty(value="sizeY")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    private ModelBinding sizeYBinding;
    @JsonIgnore
    @XMLProperty(value="posX")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    private ModelBinding positionXBinding;
    @JsonIgnore
    @XMLProperty(value="posY")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    private ModelBinding positionYBinding;

    public Widget(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.attributeHolder = new AttributeHolderBuilder().attribute(new SizeXAttribute(this.getForm(), (Component)this, this.sizeXBinding)).attribute(new SizeYAttribute(this.getForm(), (Component)this, this.sizeYBinding)).attribute(new XPosAttribute(this.getForm(), (Component)this, this.positionXBinding)).attribute(new YPosAttribute(this.getForm(), (Component)this, this.positionYBinding)).build();
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        if (this.attributeHolder != null) {
            this.attributeHolder.updateView((Component)this, elementChanges);
        }
        return elementChanges;
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        Boolean markAsDeleted;
        super.updateModel(valueChange);
        if (this.attributeHolder != null) {
            this.attributeHolder.updateModel((Component)this.getForm(), valueChange);
        }
        if (Boolean.TRUE.equals(markAsDeleted = valueChange.getBooleanAttribute("markAsDeleted"))) {
            this.markAsDeleted = markAsDeleted;
        }
    }

    public AttributeHolder getAttributeHolder() {
        return this.attributeHolder;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMarkAsDeleted() {
        return this.markAsDeleted;
    }

    public void setMarkAsDeleted(boolean markAsDeleted) {
        this.markAsDeleted = markAsDeleted;
    }

    public ModelBinding getSizeXBinding() {
        return this.sizeXBinding;
    }

    public void setSizeXBinding(ModelBinding sizeXBinding) {
        this.sizeXBinding = sizeXBinding;
    }

    public ModelBinding getSizeYBinding() {
        return this.sizeYBinding;
    }

    public void setSizeYBinding(ModelBinding sizeYBinding) {
        this.sizeYBinding = sizeYBinding;
    }

    public ModelBinding getPositionXBinding() {
        return this.positionXBinding;
    }

    public void setPositionXBinding(ModelBinding positionXBinding) {
        this.positionXBinding = positionXBinding;
    }

    public ModelBinding getPositionYBinding() {
        return this.positionYBinding;
    }

    public void setPositionYBinding(ModelBinding positionYBinding) {
        this.positionYBinding = positionYBinding;
    }
}

