/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.codegen.client;

import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.java.codegen.CodegenUtils;
import software.amazon.smithy.java.codegen.JavaSymbolProvider;
import software.amazon.smithy.java.codegen.SymbolProperties;
import software.amazon.smithy.java.codegen.client.ClientSymbolProperties;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;

final class ClientJavaSymbolProvider
extends JavaSymbolProvider {
    private final String serviceName;

    public ClientJavaSymbolProvider(Model model, ServiceShape service, String packageNamespace, String serviceName) {
        super(model, service, packageNamespace);
        this.serviceName = serviceName;
    }

    public Symbol serviceShape(ServiceShape serviceShape) {
        return ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)this.getSymbolFromName(false).toBuilder().putProperty(ClientSymbolProperties.ASYNC_SYMBOL, (Object)this.getSymbolFromName(true))).putProperty(SymbolProperties.SERVICE_EXCEPTION, (Object)CodegenUtils.getServiceExceptionSymbol((String)this.packageNamespace(), (String)this.serviceName))).putProperty(SymbolProperties.SERVICE_API_SERVICE, (Object)CodegenUtils.getServiceApiSymbol((String)this.packageNamespace(), (String)this.serviceName))).build();
    }

    private Symbol getSymbolFromName(boolean async) {
        String name = async ? this.serviceName + "AsyncClient" : this.serviceName + "Client";
        Symbol symbol = ((Symbol.Builder)((Symbol.Builder)Symbol.builder().name(name).putProperty(SymbolProperties.IS_PRIMITIVE, (Object)false)).putProperty(ClientSymbolProperties.ASYNC, (Object)async)).namespace(String.format("%s.client", this.packageNamespace()), ".").definitionFile(String.format("./%s/client/%s.java", this.packageNamespace().replace(".", "/"), name)).build();
        return ((Symbol.Builder)symbol.toBuilder().putProperty(ClientSymbolProperties.CLIENT_IMPL, (Object)symbol.toBuilder().name(name + "Impl").definitionFile(String.format("./%s/client/%sImpl.java", this.packageNamespace().replace(".", "/"), name)).build())).build();
    }
}

