/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.codegen.client;

import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.codegen.core.directed.CodegenDirector;
import software.amazon.smithy.codegen.core.directed.DirectedCodegen;
import software.amazon.smithy.framework.transform.AddFrameworkErrorsTransform;
import software.amazon.smithy.java.codegen.DefaultTransforms;
import software.amazon.smithy.java.codegen.JavaCodegenIntegration;
import software.amazon.smithy.java.codegen.JavaCodegenSettings;
import software.amazon.smithy.java.codegen.client.DirectedJavaClientCodegen;
import software.amazon.smithy.java.logging.InternalLogger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class JavaClientCodegenPlugin
implements SmithyBuildPlugin {
    private static final InternalLogger LOGGER = InternalLogger.getLogger(JavaClientCodegenPlugin.class);

    public String getName() {
        return "java-client-codegen";
    }

    public void execute(PluginContext context) {
        CodegenDirector runner = new CodegenDirector();
        JavaCodegenSettings settings = JavaCodegenSettings.fromNode((ObjectNode)context.getSettings());
        runner.settings((Object)settings);
        runner.directedCodegen((DirectedCodegen)new DirectedJavaClientCodegen());
        runner.fileManifest(context.getFileManifest());
        runner.service(settings.service());
        Model model = AddFrameworkErrorsTransform.transform((ModelTransformer)ModelTransformer.create(), (Model)context.getModel());
        runner.model(model);
        runner.integrationClass(JavaCodegenIntegration.class);
        DefaultTransforms.apply((CodegenDirector)runner, (JavaCodegenSettings)settings);
        runner.run();
        LOGGER.info("Smithy-Java client code generation complete", new Object[0]);
    }
}

