/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.codegen.client.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.framework.knowledge.ImplicitErrorIndex;
import software.amazon.smithy.java.client.core.Client;
import software.amazon.smithy.java.client.core.RequestOverrideConfig;
import software.amazon.smithy.java.codegen.CodeGenerationContext;
import software.amazon.smithy.java.codegen.CodegenUtils;
import software.amazon.smithy.java.codegen.JavaCodegenSettings;
import software.amazon.smithy.java.codegen.client.ClientSymbolProperties;
import software.amazon.smithy.java.codegen.client.sections.ClientImplAdditionalMethodsSection;
import software.amazon.smithy.java.codegen.generators.TypeRegistryGenerator;
import software.amazon.smithy.java.codegen.sections.ApplyDocumentation;
import software.amazon.smithy.java.codegen.sections.ClassSection;
import software.amazon.smithy.java.codegen.writer.JavaWriter;
import software.amazon.smithy.java.core.serde.TypeRegistry;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.CodeSection;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public final class ClientImplementationGenerator
implements Consumer<GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings>> {
    @Override
    public void accept(GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings> directive) {
        ClientImplementationGenerator.writeForSymbol(directive.symbol(), directive);
        ClientImplementationGenerator.writeForSymbol((Symbol)directive.symbol().expectProperty(ClientSymbolProperties.ASYNC_SYMBOL), directive);
    }

    public static void writeForSymbol(Symbol symbol, GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings> directive) {
        Symbol impl = (Symbol)symbol.expectProperty(ClientSymbolProperties.CLIENT_IMPL);
        ((CodeGenerationContext)directive.context()).writerDelegator().useFileWriter(impl.getDefinitionFile(), impl.getNamespace(), writer -> {
            writer.pushState((CodeSection)new ClassSection(directive.shape(), ApplyDocumentation.NONE));
            String template = "final class ${impl:T} extends ${client:T} implements ${interface:T} {${?implicitErrors}\n    ${typeRegistry:C|}${/implicitErrors}\n\n    ${impl:T}(${interface:T}.Builder builder) {\n        super(builder);\n    }\n\n    ${operations:C|}\n\n    ${?implicitErrors}@Override\n    protected ${typeRegistryClass:T} typeRegistry() {\n        return TYPE_REGISTRY;\n    }${/implicitErrors}\n}\n";
            writer.putContext("client", Client.class);
            writer.putContext("interface", (Object)symbol);
            writer.putContext("impl", (Object)impl);
            writer.putContext("future", CompletableFuture.class);
            writer.putContext("typeRegistryClass", TypeRegistry.class);
            writer.putContext("completionException", CompletionException.class);
            List<Symbol> errorSymbols = ClientImplementationGenerator.getImplicitErrorSymbols(directive.symbolProvider(), directive.model(), directive.service());
            writer.putContext("implicitErrors", (Object)(!errorSymbols.isEmpty() ? 1 : 0));
            writer.putContext("typeRegistry", (Object)new TypeRegistryGenerator(writer, errorSymbols));
            writer.putContext("operations", (Object)new OperationMethodGenerator((JavaWriter)writer, (ServiceShape)directive.shape(), directive.symbolProvider(), directive.model(), (Boolean)symbol.expectProperty(ClientSymbolProperties.ASYNC)));
            writer.write((Object)template, new Object[0]);
            writer.popState();
        });
    }

    private static List<Symbol> getImplicitErrorSymbols(SymbolProvider symbolProvider, Model model, ServiceShape service) {
        ImplicitErrorIndex implicitIndex = ImplicitErrorIndex.of((Model)model);
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (ShapeId errorId : implicitIndex.getImplicitErrorsForService((ToShapeId)service)) {
            Shape shape = model.expectShape(errorId);
            symbols.add(symbolProvider.toSymbol(shape));
        }
        return symbols;
    }

    private record OperationMethodGenerator(JavaWriter writer, ServiceShape service, SymbolProvider symbolProvider, Model model, boolean async) implements Runnable
    {
        @Override
        public void run() {
            this.writer.pushState();
            String template = "@Override\npublic ${?async}${future:T}<${/async}${output:T}${?async}>${/async} ${name:L}(${input:T} input, ${overrideConfig:T} overrideConfig) {\n    ${^async}try {\n        ${/async}return call(input, ${operation:T}.instance(), overrideConfig)${^async}.join()${/async};${^async}\n    } catch (${completionException:T} e) {\n        throw unwrapAndThrow(e);\n    }${/async}\n}\n";
            this.writer.putContext("async", (Object)this.async);
            this.writer.putContext("overrideConfig", RequestOverrideConfig.class);
            OperationIndex opIndex = OperationIndex.of((Model)this.model);
            for (OperationShape operation : TopDownIndex.of((Model)this.model).getContainedOperations((ToShapeId)this.service)) {
                this.writer.pushState();
                this.writer.putContext("name", (Object)StringUtils.uncapitalize((String)CodegenUtils.getDefaultName((Shape)operation, (ServiceShape)this.service)));
                this.writer.putContext("operation", (Object)this.symbolProvider.toSymbol((Shape)operation));
                this.writer.putContext("input", (Object)this.symbolProvider.toSymbol((Shape)opIndex.expectInputShape((ToShapeId)operation)));
                this.writer.putContext("output", (Object)this.symbolProvider.toSymbol((Shape)opIndex.expectOutputShape((ToShapeId)operation)));
                this.writer.write((Object)template, new Object[0]);
                this.writer.popState();
            }
            this.writer.injectSection((CodeSection)new ClientImplAdditionalMethodsSection(this.service, this.async));
            this.writer.popState();
        }
    }
}

