/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.codegen.client.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.java.client.core.Client;
import software.amazon.smithy.java.client.core.ClientConfig;
import software.amazon.smithy.java.client.core.ClientPlugin;
import software.amazon.smithy.java.client.core.ClientProtocolFactory;
import software.amazon.smithy.java.client.core.ClientSetting;
import software.amazon.smithy.java.client.core.ClientTransportFactory;
import software.amazon.smithy.java.client.core.ProtocolSettings;
import software.amazon.smithy.java.client.core.RequestOverrideConfig;
import software.amazon.smithy.java.client.core.auth.scheme.AuthSchemeFactory;
import software.amazon.smithy.java.client.core.pagination.AsyncPaginator;
import software.amazon.smithy.java.client.core.pagination.Paginator;
import software.amazon.smithy.java.codegen.CodeGenerationContext;
import software.amazon.smithy.java.codegen.CodegenUtils;
import software.amazon.smithy.java.codegen.JavaCodegenSettings;
import software.amazon.smithy.java.codegen.SymbolProperties;
import software.amazon.smithy.java.codegen.TraitInitializer;
import software.amazon.smithy.java.codegen.client.ClientSymbolProperties;
import software.amazon.smithy.java.codegen.client.sections.ClientInterfaceAdditionalMethodsSection;
import software.amazon.smithy.java.codegen.integrations.core.GenericTraitInitializer;
import software.amazon.smithy.java.codegen.sections.ClassSection;
import software.amazon.smithy.java.codegen.sections.OperationSection;
import software.amazon.smithy.java.codegen.writer.JavaWriter;
import software.amazon.smithy.java.core.serde.document.Document;
import software.amazon.smithy.java.logging.InternalLogger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.CodeSection;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public final class ClientInterfaceGenerator
implements Consumer<GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings>> {
    private static final InternalLogger LOGGER = InternalLogger.getLogger(ClientInterfaceGenerator.class);
    private static final Map<ShapeId, Class<? extends AuthSchemeFactory>> authSchemeFactories = new HashMap<ShapeId, Class<? extends AuthSchemeFactory>>();
    private static final Map<String, Class<? extends ClientTransportFactory>> clientTransportFactories = new HashMap<String, Class<? extends ClientTransportFactory>>();

    @Override
    public void accept(GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings> directive) {
        ClientInterfaceGenerator.writeForSymbol(directive.symbol(), directive);
        ClientInterfaceGenerator.writeForSymbol((Symbol)directive.symbol().expectProperty(ClientSymbolProperties.ASYNC_SYMBOL), directive);
    }

    private static void writeForSymbol(Symbol symbol, GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings> directive) {
        ((CodeGenerationContext)directive.context()).writerDelegator().useFileWriter(symbol.getDefinitionFile(), symbol.getNamespace(), writer -> {
            writer.pushState((CodeSection)new ClassSection(directive.shape()));
            String template = "public interface ${interface:T} {\n\n    ${operations:C|}\n\n    /**\n     * @return Configuration in use by client.\n     */\n    ${clientConfig:T} config();\n\n    /**\n     * Create a Builder for {@link ${interface:T}}.\n     */\n    static Builder builder() {\n        return new Builder();\n    }\n\n    /**\n     * Create a {@link ${requestOverride:T}} builder for this client.\n     */\n    static RequestOverrideBuilder requestOverrideBuilder() {\n        return new RequestOverrideBuilder();\n    }\n\n    /**\n     * Builder for {@link ${interface:T}}.\n     */\n    final class Builder extends ${client:T}.Builder<${interface:T}, Builder>${?settings}\n        implements ${#settings}${value:T}<Builder>${^key.last}, ${/key.last}${/settings}${/settings} {\n        ${?hasDefaults}${defaultPlugins:C|}\n        ${/hasDefaults}${?hasDefaultProtocol}${defaultProtocol:C|}\n        ${/hasDefaultProtocol}${?hasTransportSettings}${transportSettings:C|}\n        ${/hasTransportSettings}${?defaultSchemes}\n        ${defaultAuth:C|}${/defaultSchemes}\n\n        private Builder() {\n            configBuilder()${?defaultSchemes}\n                .putSupportedAuthSchemes(${#defaultSchemes}${value:L}.createAuthScheme(${key:L})${^key.last}, ${/key.last}${/defaultSchemes})${/defaultSchemes}\n                .service(${serviceApi:T}.instance());\n        }\n\n        @Override\n        public ${interface:T} build() {\n            ${?hasDefaults}for (var plugin : defaultPlugins) {\n                configBuilder().applyPlugin(plugin);\n            }\n            ${/hasDefaults}${?hasDefaultProtocol}if (configBuilder().protocol() == null) {\n                configBuilder().protocol(${protocolFactory:C}.createProtocol(protocolSettings, protocolTrait));\n            }\n            ${/hasDefaultProtocol}${?hasDefaultTransport}if (configBuilder().transport() == null) {\n                configBuilder().transport(${transportFactory:C}.createTransport(${?hasTransportSettings}transportSettings${/hasTransportSettings}));\n            }${/hasDefaultTransport}\n            return new ${impl:T}(this);\n        }\n    }\n\n    /**\n     * Builder used to create a {@link ${requestOverride:T}} for {@link ${interface:T}} operations.\n     */\n    final class RequestOverrideBuilder extends ${requestOverride:T}.OverrideBuilder<RequestOverrideBuilder>${?settings}\n        implements ${#settings}${value:T}<RequestOverrideBuilder>${^key.last}, ${/key.last}${/settings}${/settings} {}\n}\n";
            JavaCodegenSettings settings = (JavaCodegenSettings)directive.settings();
            Trait defaultProtocolTrait = ClientInterfaceGenerator.getDefaultProtocolTrait(directive.model(), settings);
            writer.putContext("hasDefaultProtocol", (Object)(defaultProtocolTrait != null ? 1 : 0));
            writer.putContext("protocolFactory", (Object)new FactoryGenerator((JavaWriter)writer, ClientInterfaceGenerator.getFactory(defaultProtocolTrait)));
            writer.putContext("defaultProtocol", (Object)new DefaultProtocolGenerator((JavaWriter)writer, settings.service(), defaultProtocolTrait, (CodeGenerationContext)directive.context()));
            writer.putContext("clientPlugin", ClientPlugin.class);
            writer.putContext("client", Client.class);
            writer.putContext("requestOverride", RequestOverrideConfig.class);
            writer.putContext("clientConfig", ClientConfig.class);
            writer.putContext("interface", (Object)symbol);
            writer.putContext("impl", symbol.expectProperty(ClientSymbolProperties.CLIENT_IMPL));
            writer.putContext("hasDefaultTransport", (Object)(settings.transport() != null ? 1 : 0));
            boolean hasTransportSettings = settings.transportSettings() != null && !settings.transportSettings().isEmpty();
            writer.putContext("hasTransportSettings", (Object)hasTransportSettings);
            writer.putContext("transportFactory", (Object)new FactoryGenerator((JavaWriter)writer, ClientInterfaceGenerator.getTransportFactory((JavaCodegenSettings)directive.settings())));
            writer.putContext("transportSettings", (Object)new TransportSettingsGenerator((JavaWriter)writer, settings.transportSettings()));
            writer.putContext("operations", (Object)new OperationMethodGenerator((JavaWriter)writer, (ServiceShape)directive.shape(), directive.symbolProvider(), symbol, directive.model()));
            Map<Trait, Class<? extends AuthSchemeFactory>> defaultAuth = ClientInterfaceGenerator.getAuthFactoryMapping(directive.model(), (ToShapeId)directive.service());
            writer.putContext("defaultAuth", (Object)new AuthInitializerGenerator((JavaWriter)writer, (CodeGenerationContext)directive.context(), defaultAuth));
            Map<String, String> schemes = ClientInterfaceGenerator.getAuthSchemes(defaultAuth.keySet());
            writer.putContext("defaultSchemes", schemes);
            Map<String, Class<? extends ClientPlugin>> defaultPlugins = ClientInterfaceGenerator.resolveDefaultPlugins((JavaCodegenSettings)directive.settings());
            writer.putContext("hasDefaults", (Object)(!defaultPlugins.isEmpty() ? 1 : 0));
            writer.putContext("defaultPlugins", (Object)new PluginPropertyWriter((JavaWriter)writer, defaultPlugins));
            writer.putContext("settings", ClientInterfaceGenerator.getBuilderSettings((JavaCodegenSettings)directive.settings()));
            Symbol serviceSymbol = directive.symbolProvider().toSymbol((Shape)directive.service());
            writer.putContext("serviceApi", serviceSymbol.expectProperty(SymbolProperties.SERVICE_API_SERVICE));
            writer.write((Object)template, new Object[0]);
            writer.popState();
        });
    }

    private static Class<? extends ClientTransportFactory> getTransportFactory(JavaCodegenSettings settings) {
        if (settings.transport() == null) {
            return null;
        }
        Class<? extends ClientTransportFactory> factory = clientTransportFactories.get(settings.transport());
        if (factory == null) {
            throw new CodegenException("Transport " + settings.transport() + " request, but no matching factory was found.");
        }
        return factory;
    }

    private static Trait getDefaultProtocolTrait(Model model, JavaCodegenSettings settings) {
        ShapeId defaultProtocol = settings.defaultProtocol();
        if (defaultProtocol == null) {
            return null;
        }
        ServiceIndex index = ServiceIndex.of((Model)model);
        Map protocols = index.getProtocols((ToShapeId)settings.service());
        if (protocols.containsKey(defaultProtocol)) {
            return (Trait)protocols.get(defaultProtocol);
        }
        throw new UnsupportedOperationException("Specified protocol `" + String.valueOf(defaultProtocol) + "` not found on service " + String.valueOf(settings.service()) + ". Expected one of: " + String.valueOf(protocols.keySet()) + ".");
    }

    private static Class<? extends ClientProtocolFactory> getFactory(Trait defaultProtocolTrait) {
        if (defaultProtocolTrait == null) {
            return null;
        }
        for (ClientProtocolFactory factory : ServiceLoader.load(ClientProtocolFactory.class, ClientInterfaceGenerator.class.getClassLoader())) {
            if (!factory.id().equals((Object)defaultProtocolTrait.toShapeId())) continue;
            return factory.getClass();
        }
        throw new CodegenException("Could not find factory for " + String.valueOf(defaultProtocolTrait));
    }

    private static Map<Trait, Class<? extends AuthSchemeFactory>> getAuthFactoryMapping(Model model, ToShapeId service) {
        ServiceIndex index = ServiceIndex.of((Model)model);
        Map schemes = index.getAuthSchemes(service);
        HashMap<Trait, Class<? extends AuthSchemeFactory>> result = new HashMap<Trait, Class<? extends AuthSchemeFactory>>();
        for (Map.Entry schemeEntry : schemes.entrySet()) {
            Class<? extends AuthSchemeFactory> schemeFactoryClass = authSchemeFactories.get(schemeEntry.getKey());
            if (schemeFactoryClass != null) {
                Class<? extends AuthSchemeFactory> existing = result.put((Trait)schemeEntry.getValue(), schemeFactoryClass);
                if (existing == null) continue;
                throw new CodegenException("Multiple auth scheme factory implementations found for scheme: " + String.valueOf(schemeEntry.getKey()) + "Found: " + String.valueOf(schemeFactoryClass) + " and " + String.valueOf(existing));
            }
            LOGGER.warn("Could not find implementation for auth scheme {}", schemeEntry.getKey());
        }
        return result;
    }

    private static Map<String, String> getAuthSchemes(Collection<Trait> traits) {
        HashMap<String, String> authSchemes = new HashMap<String, String>();
        for (Trait trait : traits) {
            String traitName = ClientInterfaceGenerator.getAuthTraitPropertyName(trait);
            authSchemes.put(traitName, traitName + "Factory");
        }
        return authSchemes;
    }

    private static String getAuthTraitPropertyName(Trait trait) {
        return StringUtils.uncapitalize((String)trait.toShapeId().getName()) + "Scheme";
    }

    private static Map<String, Class<? extends ClientPlugin>> resolveDefaultPlugins(JavaCodegenSettings settings) {
        LinkedHashMap<String, Class<? extends ClientPlugin>> pluginMap = new LinkedHashMap<String, Class<? extends ClientPlugin>>();
        HashMap<String, Integer> frequencyMap = new HashMap<String, Integer>();
        for (String pluginFqn : settings.defaultPlugins()) {
            Class pluginClass = CodegenUtils.getImplementationByName(ClientPlugin.class, (String)pluginFqn);
            Object pluginName = StringUtils.uncapitalize((String)pluginClass.getSimpleName());
            int val = frequencyMap.getOrDefault(pluginName, 0);
            if (val != 0) {
                pluginName = (String)pluginName + val;
            }
            frequencyMap.put((String)pluginName, val + 1);
            pluginMap.put((String)pluginName, pluginClass);
        }
        return pluginMap;
    }

    private static List<Class<?>> getBuilderSettings(JavaCodegenSettings settings) {
        ArrayList result = new ArrayList();
        for (String settingName : settings.defaultSettings()) {
            Class clazz = CodegenUtils.getClassForName((String)settingName);
            if (clazz.isAssignableFrom(ClientSetting.class)) {
                throw new CodegenException("Settings must extend from `ClientSetting` interface. Could not cast class `" + settingName + "` to `ClientSetting");
            }
            result.add(clazz);
        }
        return result;
    }

    static {
        ServiceLoader.load(AuthSchemeFactory.class, ClientInterfaceGenerator.class.getClassLoader()).forEach(service -> authSchemeFactories.put(service.schemeId(), service.getClass()));
        ServiceLoader.load(ClientTransportFactory.class, ClientInterfaceGenerator.class.getClassLoader()).forEach(service -> clientTransportFactories.put(service.name(), service.getClass()));
    }

    private record FactoryGenerator(JavaWriter writer, Class<?> factoryClass) implements Runnable
    {
        @Override
        public void run() {
            this.writer.pushState();
            if (this.factoryClass.isMemberClass()) {
                this.writer.putContext("outer", this.factoryClass.getEnclosingClass());
            }
            this.writer.putContext("name", (Object)this.factoryClass.getSimpleName());
            this.writer.putContext("type", this.factoryClass);
            this.writer.write((Object)"new ${?outer}${outer:T}.${name:L}${/outer}${^outer}${type:T}${/outer}()", new Object[0]);
            this.writer.popState();
        }
    }

    private record DefaultProtocolGenerator(JavaWriter writer, ShapeId service, Trait defaultProtocolTrait, CodeGenerationContext context) implements Runnable
    {
        @Override
        public void run() {
            if (this.defaultProtocolTrait == null) {
                return;
            }
            this.writer.pushState();
            String template = "private static final ${protocolSettings:T} protocolSettings = ${protocolSettings:T}.builder()\n        .service(${shapeId:T}.from(${service:S}))\n        .build();\nprivate static final ${trait:T} protocolTrait = ${initializer:C};\n";
            this.writer.putContext("protocolSettings", ProtocolSettings.class);
            this.writer.putContext("trait", (Object)this.defaultProtocolTrait.getClass());
            TraitInitializer initializer = this.context.getInitializer(this.defaultProtocolTrait);
            this.writer.putContext("initializer", (Object)this.writer.consumer(w -> initializer.accept(w, (Object)this.defaultProtocolTrait)));
            this.writer.putContext("shapeId", ShapeId.class);
            this.writer.putContext("service", (Object)this.service);
            this.writer.write((Object)template, new Object[0]);
            this.writer.popState();
        }
    }

    private record TransportSettingsGenerator(JavaWriter writer, ObjectNode settings) implements Runnable
    {
        @Override
        public void run() {
            this.writer.pushState();
            this.writer.putContext("document", Document.class);
            this.writer.putContext("nodeWriter", (Object)new NodeDocumentWriter(this.writer, this.settings));
            this.writer.write((Object)"private static final ${document:T} transportSettings = ${nodeWriter:C};", new Object[0]);
            this.writer.popState();
        }
    }

    private record OperationMethodGenerator(JavaWriter writer, ServiceShape service, SymbolProvider symbolProvider, Symbol symbol, Model model) implements Runnable
    {
        @Override
        public void run() {
            String templateDefault = "default ${?async}${future:T}<${/async}${output:T}${?async}>${/async} ${name:L}(${input:T} input) {\n    return ${name:L}(input, null);\n}\n";
            String templateBase = "${?async}${future:T}<${/async}${output:T}${?async}>${/async} ${name:L}(${input:T} input, ${overrideConfig:T} overrideConfig);\n";
            String templatePaginated = "/**\n * Returns a {@link ${paginator:T}} for the {@link #${name:L}} operation.\n *\n * @param input Input to use as basis for paginated calls.\n * @return Paginator that can be used to retrieval paginated results.\n */\ndefault ${paginator:T}<${output:T}> ${name:L}Paginator(${input:T} input) {\n    return ${paginator:T}.paginate(input, ${operation:T}.instance(), this::${name:L});\n}\n";
            this.writer.pushState();
            Boolean isAsync = (Boolean)this.symbol.expectProperty(ClientSymbolProperties.ASYNC);
            this.writer.putContext("async", (Object)isAsync);
            this.writer.putContext("overrideConfig", RequestOverrideConfig.class);
            this.writer.putContext("future", CompletableFuture.class);
            this.writer.putContext("paginator", isAsync != false ? AsyncPaginator.class : Paginator.class);
            OperationIndex opIndex = OperationIndex.of((Model)this.model);
            for (OperationShape operation : TopDownIndex.of((Model)this.model).getContainedOperations((ToShapeId)this.service)) {
                this.writer.pushState();
                this.writer.putContext("name", (Object)StringUtils.uncapitalize((String)CodegenUtils.getDefaultName((Shape)operation, (ServiceShape)this.service)));
                this.writer.putContext("input", (Object)this.symbolProvider.toSymbol((Shape)opIndex.expectInputShape((ToShapeId)operation)));
                this.writer.putContext("output", (Object)this.symbolProvider.toSymbol((Shape)opIndex.expectOutputShape((ToShapeId)operation)));
                this.writer.pushState((CodeSection)new OperationSection(operation, this.symbolProvider, this.model));
                this.writer.write((Object)templateDefault, new Object[0]);
                this.writer.popState();
                this.writer.newLine();
                this.writer.pushState((CodeSection)new OperationSection(operation, this.symbolProvider, this.model));
                this.writer.write((Object)templateBase, new Object[0]);
                this.writer.popState();
                if (operation.hasTrait(PaginatedTrait.class)) {
                    this.writer.pushState();
                    this.writer.newLine();
                    this.writer.putContext("operation", (Object)this.symbolProvider.toSymbol((Shape)operation));
                    this.writer.write((Object)templatePaginated, new Object[0]);
                    this.writer.popState();
                }
                this.writer.popState();
            }
            this.writer.injectSection((CodeSection)new ClientInterfaceAdditionalMethodsSection(this.service, isAsync));
            this.writer.popState();
        }
    }

    private record AuthInitializerGenerator(JavaWriter writer, CodeGenerationContext context, Map<Trait, Class<? extends AuthSchemeFactory>> authMapping) implements Runnable
    {
        @Override
        public void run() {
            this.writer.pushState();
            for (Map.Entry<Trait, Class<? extends AuthSchemeFactory>> entry : this.authMapping.entrySet()) {
                String template = "private static final ${trait:T} ${traitName:L} = ${?cast}(${trait:T}) ${/cast}${initializer:C};\nprivate static final ${authFactory:T}<${trait:T}> ${traitName:L}Factory = new ${?outer}${outer:T}.${authFactoryImplName:L}${/outer}${^outer}${authFactoryImpl:T}${/outer}();\n";
                Trait trait = entry.getKey();
                this.writer.putContext("trait", (Object)trait.getClass());
                this.writer.putContext("traitName", (Object)ClientInterfaceGenerator.getAuthTraitPropertyName(trait));
                TraitInitializer initializer = this.context.getInitializer(entry.getKey());
                this.writer.putContext("cast", (Object)initializer.getClass().equals(GenericTraitInitializer.class));
                this.writer.putContext("initializer", (Object)this.writer.consumer(w -> initializer.accept(w, (Object)((Trait)entry.getKey()))));
                this.writer.putContext("authFactory", AuthSchemeFactory.class);
                this.writer.putContext("authFactoryImpl", entry.getValue());
                if (entry.getValue().isMemberClass()) {
                    this.writer.putContext("outer", entry.getValue().getEnclosingClass());
                }
                this.writer.putContext("authFactoryImplName", (Object)entry.getValue().getSimpleName());
                this.writer.write((Object)template, new Object[0]);
            }
            this.writer.popState();
        }
    }

    private record PluginPropertyWriter(JavaWriter writer, Map<String, Class<? extends ClientPlugin>> pluginMap) implements Runnable
    {
        @Override
        public void run() {
            if (this.pluginMap.isEmpty()) {
                return;
            }
            this.writer.pushState();
            this.writer.putContext("list", List.class);
            this.writer.putContext("plugins", this.pluginMap);
            this.writer.write((Object)"${#plugins}private final ${value:T} ${key:L} = new ${value:T}();\n${/plugins}\nprivate final ${list:T}<${clientPlugin:T}> defaultPlugins = List.of(${#plugins}${key:L}${^key.last}, ${/key.last}${/plugins});\n", new Object[0]);
            this.writer.popState();
        }
    }

    private record NodeDocumentWriter(JavaWriter writer, ObjectNode node) implements NodeVisitor<Void>,
    Runnable
    {
        @Override
        public void run() {
            this.node.accept((NodeVisitor)this);
        }

        public Void arrayNode(ArrayNode arrayNode) {
            List<Runnable> consumers = arrayNode.getElements().stream().map(n -> () -> n.accept((NodeVisitor)this)).toList();
            this.writer.pushState();
            this.writer.putContext("nodes", consumers);
            this.writer.putContext("list", List.class);
            this.writer.write((Object)"${document:T}.of(${list:T}.of(${#nodes}${value:C}${^key.last}, ${/key.last}${/nodes}))", new Object[0]);
            this.writer.popState();
            return null;
        }

        public Void objectNode(ObjectNode objectNode) {
            this.writer.pushState();
            this.writer.putContext("map", Map.class);
            this.writer.openBlock("${document:T}.of(${map:T}.of(", "))", () -> {
                Iterator iter = objectNode.getMembers().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.writer.writeInline((Object)"$S, $C", new Object[]{((StringNode)entry.getKey()).getValue(), () -> ((Node)entry.getValue()).accept((NodeVisitor)this)});
                    if (iter.hasNext()) {
                        this.writer.writeInline((Object)",", new Object[0]);
                    }
                    this.writer.newLine();
                }
            });
            this.writer.popState();
            return null;
        }

        public Void booleanNode(BooleanNode booleanNode) {
            this.writer.writeInline((Object)"${document:T}.of($L)", new Object[]{booleanNode.getValue()});
            return null;
        }

        public Void numberNode(NumberNode numberNode) {
            this.writer.writeInline((Object)"${document:T}.ofNumber($L)", new Object[]{numberNode.getValue()});
            return null;
        }

        public Void stringNode(StringNode stringNode) {
            this.writer.writeInline((Object)"${document:T}.of($S)", new Object[]{stringNode.getValue()});
            return null;
        }

        public Void nullNode(NullNode nullNode) {
            throw new IllegalArgumentException("Null nodes not supported in transport settings.");
        }
    }
}

