/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.elixirapi.requests.player;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.function.Consumer;
import tech.xigam.elixirapi.Bot;
import tech.xigam.elixirapi.ElixirAPI;
import tech.xigam.elixirapi.Request;
import tech.xigam.elixirapi.interfaces.PlayerResponse;
import tech.xigam.elixirapi.objects.TrackObject;
import tech.xigam.elixirapi.requests.player.PlayerRequest;
import tech.xigam.elixirapi.responses.TrackResponse;

public final class GetPlayingTrackRequest
extends PlayerRequest {
    private final String guild;

    public GetPlayingTrackRequest(ElixirAPI api, Bot bot, String guild) {
        super(api, bot);
        this.guild = guild;
    }

    @Override
    public void execute(Consumer<PlayerResponse> response) {
        Request request = new Request.Builder(this.api).method(Request.Method.GET).endpoint("nowplaying").argument("bot", this.bot.getBotId()).argument("guild", this.guild).build();
        request.execute((tech.xigam.elixirapi.Response res) -> response.accept(new Response(res.getResponse(), res.getResponseCode())));
    }

    public static class Response
    extends TrackResponse {
        public Response(String response, int responseCode) {
            super(response, responseCode);
        }

        @Override
        public TrackObject getAsTrack() {
            JsonObject jsonObject = JsonParser.parseString((String)this.getResponse()).getAsJsonObject();
            return (TrackObject)new Gson().fromJson(jsonObject.get("nowplaying"), TrackObject.class);
        }
    }

    public static class Builder
    extends PlayerRequest.Builder {
        public Builder(ElixirAPI api) {
            super(api);
        }

        @Override
        public GetPlayingTrackRequest build() {
            if (this.bot == null) {
                this.bot = this.api.preferredBot();
            }
            return new GetPlayingTrackRequest(this.api, this.bot, this.guild);
        }
    }
}

