/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.webdav;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import uk.co.firstzero.webdav.Common;

public class Push
extends Task {
    private static Logger logger = Logger.getLogger(Push.class);
    private String user;
    private String password;
    private String url;
    Vector<FileSet> fileSets = new Vector();
    private boolean overwrite;
    private String proxyUser;
    private String proxyPassword;
    private String proxyHost;
    private int proxyPort = Integer.MIN_VALUE;
    private HttpClient httpClient;

    public Push() {
    }

    public Push(String user, String password, String url) throws MalformedURLException {
        this.setUser(user);
        this.setPassword(password);
        this.setUrl(url);
        this.setUp();
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        logger.trace((Object)("proxyHost is " + proxyHost));
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        logger.trace((Object)("proxyHost is " + proxyPort));
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        logger.trace((Object)("proxyHost is " + proxyUser));
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        logger.trace((Object)("proxyHost is " + proxyPassword));
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void addFileSet(FileSet fileSet) {
        if (!this.fileSets.contains(fileSet)) {
            this.fileSets.add(fileSet);
        }
    }

    public void setUp() throws MalformedURLException {
        this.httpClient = new HttpClient();
        this.httpClient = Common.setProxy(this.httpClient, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
        this.httpClient = Common.setCredentials(this.httpClient, this.url, this.user, this.password);
    }

    public void execute() {
        try {
            this.setUp();
            for (FileSet fileset : this.fileSets) {
                String[] filesInSet;
                DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
                File dir = ds.getBasedir();
                for (String filename : filesInSet = ds.getIncludedFiles()) {
                    logger.info((Object)("Uploading " + filename));
                    File f = new File(dir, filename);
                    this.createDirectory(filename, f.getName());
                    boolean result = this.uploadFile(f, filename);
                    logger.info((Object)("Upload status of " + filename + " - " + result));
                }
            }
        }
        catch (HttpException e) {
            logger.error((Object)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private void createDirectory(String path, String fileName) {
        try {
            String directoryPath = path.split(fileName)[0].trim();
            String uploadUrl = this.url;
            String[] directories = directoryPath.split(File.separator);
            if (directoryPath.length() > 0) {
                for (String directoryName : directories) {
                    MkColMethod mkdir = new MkColMethod(uploadUrl = uploadUrl + "/" + directoryName);
                    int status = this.httpClient.executeMethod((HttpMethod)mkdir);
                    if (status == 405) {
                        logger.trace((Object)"Directory exists");
                        continue;
                    }
                    if (status != 201) {
                        logger.error((Object)("ERR  " + status + " " + uploadUrl));
                        continue;
                    }
                    logger.debug((Object)("Directory " + uploadUrl + " created"));
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            logger.error((Object)("ERR creating " + path));
            logger.error((Object)e);
        }
    }

    public void uploadFile(File f) throws IOException {
        this.uploadFile(f, f.getName());
    }

    public boolean uploadFile(File f, String filename) throws IOException {
        String uploadUrl = this.url + "/" + filename;
        boolean uploaded = false;
        this.deleteFile(uploadUrl);
        PutMethod putMethod = new PutMethod(uploadUrl);
        logger.debug((Object)("Check if file exists - " + this.fileExists(uploadUrl)));
        if (!this.fileExists(uploadUrl)) {
            InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)new FileInputStream(f));
            putMethod.setRequestEntity((RequestEntity)requestEntity);
            this.httpClient.executeMethod((HttpMethod)putMethod);
            logger.trace((Object)("uploadFile - statusCode - " + putMethod.getStatusCode()));
            switch (putMethod.getStatusCode()) {
                case 204: {
                    logger.info((Object)("IGNORE - File already exists " + f.getAbsolutePath()));
                    break;
                }
                case 200: {
                    uploaded = true;
                    logger.info((Object)("Transferred " + f.getAbsolutePath()));
                    break;
                }
                case 201: {
                    uploaded = true;
                    logger.info((Object)("Transferred " + f.getAbsolutePath()));
                    break;
                }
                default: {
                    logger.error((Object)("ERR  " + putMethod.getStatusCode() + " " + putMethod.getStatusText() + " " + f.getAbsolutePath()));
                    break;
                }
            }
        } else {
            logger.info((Object)("IGNORE - File already exists " + f.getAbsolutePath()));
        }
        return uploaded;
    }

    public boolean fileExists(String url) throws IOException {
        return Common.executeMethod(this.httpClient, (HttpMethod)new HeadMethod(url), true);
    }

    public boolean deleteFile(String url) {
        boolean deleted = true;
        try {
            logger.debug((Object)("Check if fileExists - " + this.fileExists(url)));
            if (this.fileExists(url) && this.overwrite) {
                deleted = Common.executeMethod(this.httpClient, (HttpMethod)new DeleteMethod(url));
            }
        }
        catch (HttpException e) {
            logger.error((Object)("Could not delete " + url));
            logger.error((Object)e);
            deleted = false;
        }
        catch (IOException e) {
            logger.error((Object)("Could not delete " + url));
            logger.error((Object)e);
            deleted = false;
        }
        return deleted;
    }
}

