/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.webdav;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.log4j.Logger;

class Common {
    private static Logger logger = Logger.getLogger(Common.class);

    Common() {
    }

    public static HttpClient setProxy(HttpClient httpClient, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        logger.trace((Object)("proxyHost is " + proxyHost));
        logger.trace((Object)("proxyPort is " + proxyPort));
        logger.trace((Object)("proxyUser is " + proxyUser));
        if (proxyHost != null && proxyPort != Integer.MIN_VALUE) {
            UsernamePasswordCredentials credsProxy;
            logger.trace((Object)"Setting up proxy");
            if (proxyUser != null) {
                credsProxy = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            } else {
                logger.trace((Object)"proxyUser is null");
                credsProxy = new UsernamePasswordCredentials("", "");
            }
            logger.trace((Object)"Applying host and port proxy");
            httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
            logger.trace((Object)"Applying authentication scope and credentials");
            httpClient.getState().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)credsProxy);
        }
        logger.trace((Object)"Completed setup of proxy");
        return httpClient;
    }

    public static HttpClient setCredentials(HttpClient httpClient, String strUrl, String user, String password) throws MalformedURLException {
        logger.trace((Object)("strUrl is " + strUrl));
        logger.trace((Object)("user is " + user));
        URL url = new URL(strUrl);
        logger.trace((Object)"Setting up username password credentials");
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, password);
        httpClient.getState().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)creds);
        logger.trace((Object)"Completed setup of username password credentials");
        return httpClient;
    }

    public static boolean executeMethod(HttpClient client, HttpMethod method) throws IOException {
        client.executeMethod(method);
        int statusCode = method.getStatusCode();
        logger.trace((Object)("executeMethod - statusCode - " + statusCode));
        boolean result = method.getStatusCode() == 200;
        logger.debug((Object)("executeMethod - result - " + result));
        logger.debug((Object)(method.getStatusCode() + " " + method.getStatusText() + " " + method.getResponseBodyAsString() + " " + Arrays.toString(method.getResponseHeaders())));
        return result;
    }

    public static boolean executeMethod(HttpClient client, HttpMethod method, boolean ignoreHTTPNOTFOUND) throws IOException {
        block2: {
            try {
                client.executeMethod(method);
            }
            catch (IOException e) {
                if (method.getStatusCode() == 404) break block2;
                throw e;
            }
        }
        int statusCode = method.getStatusCode();
        logger.trace((Object)("executeMethod - statusCode - " + statusCode));
        boolean result = method.getStatusCode() == 200;
        logger.debug((Object)("executeMethod - result - " + result));
        logger.debug((Object)(method.getStatusCode() + " " + method.getStatusText() + " " + method.getResponseBodyAsString() + " " + Arrays.toString(method.getResponseHeaders())));
        return result;
    }
}

