/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.co.firstzero.xml.ModifyPath;

public class AntXPath
extends Task {
    Logger logger = Logger.getLogger(AntXPath.class);
    private Vector<FileSet> fileSets = new Vector();
    private List<ModifyPath> modifyPaths = new ArrayList<ModifyPath>();
    private String outputDirectory;
    private String renamePattern;
    private String patternSplitter = "#";
    private DocumentBuilder builder;
    private Transformer xFormer;
    private XPathFactory xPathFactory;

    public XPathFactory getXPathFactory() {
        if (this.xPathFactory == null) {
            this.xPathFactory = XPathFactory.newInstance();
        }
        return this.xPathFactory;
    }

    public void addFileSet(FileSet fileset) {
        if (!this.fileSets.contains(fileset)) {
            this.fileSets.add(fileset);
        }
    }

    public void addModifyPath(ModifyPath path) {
        this.modifyPaths.add(path);
    }

    public void setModifyPaths(List<ModifyPath> modifyPaths) {
        this.modifyPaths = modifyPaths;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setRenamePattern(String renamePattern) {
        this.renamePattern = renamePattern;
    }

    public void execute() {
        try {
            this.preSetup();
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)"Unable to run preSetup() to setup dependencies");
            this.logger.error((Object)e);
            System.exit(1);
        }
        catch (TransformerConfigurationException e) {
            this.logger.error((Object)"Unable to run preSetup() to setup dependencies");
            this.logger.error((Object)e);
            System.exit(1);
        }
        for (FileSet fileset : this.fileSets) {
            String[] filesInSet;
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            File dir = ds.getBasedir();
            for (String filename : filesInSet = ds.getIncludedFiles()) {
                this.logger.debug((Object)("Processing " + filename));
                File f = new File(dir, filename);
                this.processFile(f);
            }
        }
    }

    private void preSetup() throws ParserConfigurationException, TransformerConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.builder = factory.newDocumentBuilder();
        this.xFormer = TransformerFactory.newInstance().newTransformer();
    }

    public void processFile(File iFile) {
        try {
            Document doc = this.builder.parse(iFile);
            this.logger.trace((Object)("Parsed " + iFile.getAbsolutePath()));
            for (ModifyPath path : this.modifyPaths) {
                this.logger.trace((Object)("Processing xPath - " + path.getPath()));
                this.logger.trace((Object)("xPath value - " + path.getValue() + " : delete - " + path.isDelete()));
                doc = this.processNode(path, doc);
            }
            this.writeDocument(doc, iFile.getName());
        }
        catch (XPathExpressionException e) {
            this.logger.error((Object)"Unable to evaluate xPath");
            this.logger.error((Object)e);
        }
        catch (TransformerException e) {
            this.logger.error((Object)"Unable to run write output xml file");
            this.logger.error((Object)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to read input file");
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)"Unable to read input file");
            this.logger.error((Object)e);
        }
    }

    public Document processNode(ModifyPath path, Document doc) throws XPathExpressionException {
        XPath xPath = this.getXPathFactory().newXPath();
        XPathExpression expr = xPath.compile(path.getPath());
        Object xPathResult = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)xPathResult;
        for (int index = 0; index < nodes.getLength(); ++index) {
            if (path.isDelete()) {
                this.delete(nodes.item(index));
                this.logger.trace((Object)("Removed node - " + path.getPath()));
                continue;
            }
            nodes.item(index).setTextContent(path.getValue());
            this.logger.trace((Object)("Modified node - " + path.getPath() + " with Value - " + path.getValue()));
        }
        return doc;
    }

    private void delete(Node node) {
        if (node != null) {
            if (node.getNodeType() == 1) {
                node.getParentNode().removeChild(node);
                this.logger.trace((Object)("Removed Element - " + node.toString()));
            } else {
                Attr a = (Attr)node;
                a.getOwnerElement().removeAttributeNode(a);
                this.logger.trace((Object)("Removed Attribute - " + node.toString()));
            }
        }
    }

    private String getNewFileName(Document doc, String fileName) {
        XPath xPath = this.xPathFactory.newXPath();
        StringBuffer sBuffer = new StringBuffer();
        try {
            if (this.renamePattern.length() > 0) {
                String[] patterns;
                this.logger.trace((Object)("renamePattern - " + this.renamePattern));
                for (String pattern : patterns = this.renamePattern.split(this.patternSplitter)) {
                    if (pattern.startsWith("/")) {
                        XPathExpression expr = xPath.compile(pattern);
                        String xPathResult = (String)expr.evaluate(doc, XPathConstants.STRING);
                        this.logger.trace((Object)("xPath Pattern Result - " + xPathResult));
                        sBuffer.append(xPathResult);
                    } else {
                        sBuffer.append(pattern);
                    }
                    this.logger.trace((Object)("String buffer - " + sBuffer.toString()));
                }
                sBuffer.append(".xml");
                return sBuffer.toString();
            }
            return fileName;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error evaluating filename");
            this.logger.error((Object)e);
            return fileName;
        }
    }

    private void writeDocument(Document doc, String fileName) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        String oFileName = this.getNewFileName(doc, fileName);
        File oFile = new File(this.outputDirectory + "/" + oFileName);
        StreamResult result = new StreamResult(oFile);
        this.logger.debug((Object)("About to write to file " + oFile.getAbsolutePath()));
        this.xFormer.transform(source, result);
    }
}

