/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.rpc.RPCParameter;

public class RPCMethod {
    int numInParams;
    int numOutParams;
    Map parameters = new HashMap();
    ArrayList orderedParameters = new ArrayList();
    Method javaMethod;
    QName qname;
    QName responseQName;

    public RPCMethod(QName qname) {
        this.qname = qname;
    }

    public ArrayList getParams() {
        return this.orderedParameters;
    }

    public void addParameter(RPCParameter param) {
        this.orderedParameters.add(param);
        this.parameters.put(param.getQName(), param);
        if (param.getMode() != 1) {
            ++this.numInParams;
        }
        if (param.getMode() != 0) {
            ++this.numOutParams;
        }
    }

    public RPCParameter getParameter(QName qname) {
        return (RPCParameter)((Object)this.parameters.get(qname));
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public void setJavaMethod(Method javaMethod) {
        this.javaMethod = javaMethod;
    }

    public QName getResponseQName() {
        return this.responseQName;
    }

    public void setResponseQName(QName responseQName) {
        this.responseQName = responseQName;
    }

    public QName getQName() {
        return this.qname;
    }

    public RPCParameter getResponseParameter() {
        Iterator i = this.orderedParameters.iterator();
        while (i.hasNext()) {
            RPCParameter parameter = (RPCParameter)((Object)i.next());
            if (parameter.getMode() != 1) continue;
            return parameter;
        }
        return null;
    }

    public Iterator getOutParams() {
        return new Outerator(this.orderedParameters, 0);
    }

    public Iterator getInParams() {
        return new Outerator(this.orderedParameters, 1);
    }

    public int getNumInParams() {
        return this.numInParams;
    }

    public int getNumOutParams() {
        return this.numOutParams;
    }

    static class Outerator
    implements Iterator {
        ArrayList params;
        RPCParameter cache = null;
        int badMode;
        int idx = 0;

        public Outerator(ArrayList params, int badMode) {
            this.params = params;
            this.badMode = badMode;
        }

        public void remove() {
        }

        public boolean hasNext() {
            if (this.cache != null) {
                return true;
            }
            while (this.idx < this.params.size()) {
                RPCParameter param = (RPCParameter)((Object)this.params.get(this.idx));
                ++this.idx;
                if (param.mode == this.badMode) continue;
                this.cache = param;
                return true;
            }
            return false;
        }

        public Object next() {
            RPCParameter ret = null;
            if (this.hasNext()) {
                ret = this.cache;
                this.cache = null;
            }
            return ret;
        }
    }
}

