/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc;

import javax.xml.namespace.QName;
import org.apache.axis2.databinding.DeserializationTarget;
import org.apache.axis2.databinding.Deserializer;
import org.apache.axis2.databinding.SerializationContext;
import org.apache.axis2.databinding.metadata.ElementDesc;
import org.apache.axis2.databinding.utils.Converter;
import org.apache.axis2.rpc.RPCValues;

public class RPCParameter
extends ElementDesc {
    public static final int MODE_IN = 0;
    public static final int MODE_OUT = 1;
    public static final int MODE_INOUT = 2;
    int mode;
    Class destClass;

    public Object getValue(RPCValues values) {
        Object value = values.getValue(this.qname);
        if (this.destClass != null) {
            return Converter.convert((Object)value, (Class)this.destClass);
        }
        return value;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public Class getDestClass() {
        return this.destClass;
    }

    public void setDestClass(Class destClass) {
        this.destClass = destClass;
    }

    public void serialize(SerializationContext context, Object value) throws Exception {
        if (this.ser == null) {
            throw new Exception("No serializer in RPCParameter");
        }
        context.serializeElement(this.qname, value, this.ser);
    }

    public Deserializer getDeserializer(int i, RPCValues values) {
        if (i > this.maxOccurs && this.maxOccurs > -1) {
            throw new RuntimeException("Too many elements");
        }
        ParamTarget target = this.maxOccurs == -1 || this.maxOccurs > 1 ? new IndexedParamTarget(this.qname, values, i) : new ParamTarget(this.qname, values);
        Deserializer dser = this.deserializerFactory.getDeserializer();
        dser.setTarget((DeserializationTarget)target);
        return dser;
    }

    class IndexedParamTarget
    extends ParamTarget {
        int index;

        public IndexedParamTarget(QName paramName, RPCValues values, int index) {
            super(paramName, values);
            this.index = index;
        }

        public void setValue(Object value) throws Exception {
            this.values.setIndexedValue(this.paramName, this.index, value);
        }
    }

    class ParamTarget
    implements DeserializationTarget {
        QName paramName;
        RPCValues values;

        public ParamTarget(QName paramName, RPCValues values) {
            this.paramName = paramName;
            this.values = values;
        }

        public void setValue(Object value) throws Exception {
            this.values.setValue(this.paramName, value);
        }
    }
}

