/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.databinding.SerializationContext;
import org.apache.axis2.om.OMContainer;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.impl.OMOutputImpl;
import org.apache.axis2.om.impl.llom.OMElementImpl;
import org.apache.axis2.rpc.RPCMethod;
import org.apache.axis2.rpc.RPCParameter;
import org.apache.axis2.rpc.RPCValues;

public class RPCResponseElement
extends OMElementImpl {
    RPCMethod method;
    RPCValues values;

    public RPCResponseElement(RPCMethod method, RPCValues values, OMElement parent) {
        super(method.getResponseQName(), (OMContainer)parent);
        this.method = method;
        this.values = values;
    }

    protected void serialize(OMOutputImpl omOutput, boolean cache) throws XMLStreamException {
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        SerializationContext context = new SerializationContext(writer);
        if (this.ns == null) {
            writer.writeStartElement(this.localName);
        } else {
            writer.writeStartElement(this.localName, this.ns.getName(), this.ns.getPrefix());
        }
        Iterator outParams = this.method.getOutParams();
        while (outParams.hasNext()) {
            RPCParameter parameter = (RPCParameter)((Object)outParams.next());
            try {
                parameter.serialize(context, this.values.getValue(parameter.getQName()));
            }
            catch (Exception e) {
                throw new XMLStreamException("Couldn't serialize RPCParameter", e);
            }
        }
        writer.writeEndElement();
        try {
            context.finish();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }
}

