/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMFactory;
import org.apache.axis2.om.OMNamespace;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.impl.llom.builder.StAXOMBuilder;
import org.apache.axis2.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFactory;

public class RPCMessageReceiver
extends AbstractInOutSyncMessageReceiver {
    private Method method;
    private String RETURN_WRAPPER = "return";

    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        try {
            Object obj = this.getTheImplementationObject(inMessage);
            Class<?> ImplClass = obj.getClass();
            DependencyManager.configureBusinessLogicProvider((Object)obj, (MessageContext)inMessage, null);
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            OMElement methodElement = inMessage.getEnvelope().getBody().getFirstElement();
            String methodName = op.getName().getLocalPart();
            Method[] methods = ImplClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                this.method = methods[i];
                break;
            }
            Object[] objectArray = this.processRequest(methodElement);
            Object resObject = this.method.invoke(obj, objectArray);
            SOAPFactory fac = this.getSOAPFactory(inMessage);
            OMNamespace ns = fac.createOMNamespace("http://soapenc/", "res");
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            OMElement bodyContent = null;
            if (resObject instanceof Object[]) {
                QName resName = new QName("http://soapenc/", this.method.getName() + "Response", "res");
                OMElement bodyChild = this.getResponseElement(resName, (Object[])resObject);
                envelope.getBody().addChild((OMNode)bodyChild);
            } else {
                this.processResponse(fac, resObject, bodyContent, ns, envelope);
            }
            outMessage.setEnvelope(envelope);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    private Object[] processRequest(OMElement methodElement) throws AxisFault {
        Object[] parameters = this.method.getParameterTypes();
        return BeanUtil.deserialize((OMElement)methodElement, (Object[])parameters);
    }

    private OMElement getResponseElement(QName resname, Object[] objs) {
        return BeanUtil.getOMElement((QName)resname, (Object[])objs);
    }

    private void processResponse(SOAPFactory fac, Object resObject, OMElement bodyContent, OMNamespace ns, SOAPEnvelope envelope) {
        if (resObject != null) {
            if (resObject instanceof OMElement) {
                bodyContent = (OMElement)resObject;
            } else if (SimpleTypeMapper.isSimpleType((Object)resObject)) {
                bodyContent = fac.createOMElement(this.method.getName() + "Response", ns);
                OMElement child = fac.createOMElement(this.RETURN_WRAPPER, null);
                child.addChild((OMNode)fac.createText(child, SimpleTypeMapper.getStringValue((Object)resObject)));
                bodyContent.addChild((OMNode)child);
            } else {
                bodyContent = fac.createOMElement(this.method.getName() + "Response", ns);
                XMLStreamReader xr = BeanUtil.getPullParser((Object)resObject, (QName)new QName(this.RETURN_WRAPPER));
                StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)xr);
                OMElement documentElement = stAXOMBuilder.getDocumentElement();
                if (documentElement != null) {
                    bodyContent.addChild((OMNode)documentElement);
                }
            }
        }
        if (bodyContent != null) {
            envelope.getBody().addChild((OMNode)bodyContent);
        }
    }
}

