/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaConstants;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaCompiler {
    private CompilerOptions options;
    private HashMap processedTypemap;
    private HashMap processedElementMap;
    private HashMap processedAnonymousComplexTypesMap;
    private HashMap simpleTypesMap;
    private HashMap changedTypeMap;
    private ArrayList processedElementList;
    private BeanWriter writer = null;
    private Map baseSchemaTypeMap = null;
    private static final String ANY_ELEMENT_FIELD_NAME = "extraElements";
    private static final String EXTRA_ATTRIBUTE_FIELD_NAME = "extraAttributes";
    static /* synthetic */ Class class$org$apache$axis2$om$OMElement;
    static /* synthetic */ Class array$Lorg$apache$axis2$om$OMElement;

    public HashMap getProcessedElementMap() {
        return this.processedElementMap;
    }

    public Map getProcessedModelMap() {
        return this.writer.getModelMap();
    }

    public SchemaCompiler(CompilerOptions options) throws SchemaCompilationException {
        this.options = options == null ? new CompilerOptions() : options;
        this.processedTypemap = new HashMap();
        this.processedElementMap = new HashMap();
        this.simpleTypesMap = new HashMap();
        this.processedElementList = new ArrayList();
        this.processedAnonymousComplexTypesMap = new HashMap();
        this.changedTypeMap = new HashMap();
        this.writer = SchemaPropertyLoader.getBeanWriterInstance();
        this.writer.init(this.options);
        this.baseSchemaTypeMap = SchemaPropertyLoader.getTypeMapperInstance().getTypeMap();
    }

    public void compile(List schemalist) throws SchemaCompilationException {
        try {
            for (int i = 0; i < schemalist.size(); ++i) {
                XmlSchema schema = (XmlSchema)schemalist.get(i);
                this.compile(schema);
            }
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public void compile(XmlSchema schema) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes = schema.getIncludes();
        if (includes != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (!(o instanceof XmlSchemaImport) || (schema1 = ((XmlSchemaImport)o).getSchema()) == null) continue;
                this.compile(schema1);
            }
        }
        XmlSchemaObjectTable elements = schema.getElements();
        Iterator xmlSchemaElement1Iterator = elements.getValues();
        while (xmlSchemaElement1Iterator.hasNext()) {
            this.processElement((XmlSchemaElement)xmlSchemaElement1Iterator.next(), true);
        }
        Iterator xmlSchemaElement2Iterator = elements.getValues();
        while (xmlSchemaElement2Iterator.hasNext()) {
            this.writeElement((XmlSchemaElement)xmlSchemaElement2Iterator.next());
        }
        if (this.options.isWrapClasses()) {
            this.writer.writeBatch();
        }
    }

    public Properties getCompilerProperties() {
        return SchemaPropertyLoader.getPropertyMap();
    }

    private void writeElement(XmlSchemaElement xsElt) throws SchemaCompilationException {
        if (this.processedElementMap.containsKey(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        if (schemaType != null) {
            BeanWriterMetaInfoHolder metainf = new BeanWriterMetaInfoHolder();
            if (schemaType.getName() != null) {
                QName qName = schemaType.getQName();
                String className = this.findClassName(qName, this.isArray((XmlSchemaParticle)xsElt));
                if (this.changedTypeMap.containsKey(qName)) {
                    metainf.registerMapping(xsElt.getQName(), (QName)this.changedTypeMap.get(qName), className);
                } else {
                    metainf.registerMapping(xsElt.getQName(), qName, className);
                }
            } else {
                metainf = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                metainf.setAnonymous(true);
            }
            String writtenClassName = this.writer.write(xsElt, (Map)this.processedTypemap, metainf);
            this.processedElementMap.put(xsElt.getQName(), writtenClassName);
        }
    }

    private void processElement(XmlSchemaElement xsElt, boolean isOuter) throws SchemaCompilationException {
        this.processElement(xsElt, isOuter, false);
    }

    private void processElement(XmlSchemaElement xsElt, boolean isOuter, boolean isArray) throws SchemaCompilationException {
        if (isOuter && this.processedElementList.contains(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        if (schemaType != null) {
            this.processSchema(xsElt, schemaType);
        }
        if (!isOuter) {
            String className = this.findClassName(xsElt.getSchemaTypeName(), this.isArray((XmlSchemaParticle)xsElt));
            this.processedElementMap.put(xsElt.getQName(), className);
        }
        this.processedElementList.add(xsElt.getQName());
    }

    private String findClassName(QName qName, boolean isArray) {
        String className = this.processedTypemap.containsKey(qName) ? (String)this.processedTypemap.get(qName) : (this.simpleTypesMap.containsKey(qName) ? (String)this.simpleTypesMap.get(qName) : (this.baseSchemaTypeMap.containsKey(qName) ? (String)this.baseSchemaTypeMap.get(qName) : (class$org$apache$axis2$om$OMElement == null ? (class$org$apache$axis2$om$OMElement = SchemaCompiler.class$("org.apache.axis2.om.OMElement")) : class$org$apache$axis2$om$OMElement).getName()));
        if (isArray) {
            className = className + "[]";
        }
        return className;
    }

    private void processSchema(XmlSchemaElement xsElt, XmlSchemaType schemaType) throws SchemaCompilationException {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
            if (complexType.getName() != null) {
                this.processNamedComplexSchemaType(complexType);
            } else {
                this.processAnonymousComplexSchemaType(xsElt, complexType);
            }
        } else if (schemaType instanceof XmlSchemaSimpleType) {
            this.processSimpleSchemaType(xsElt, (XmlSchemaSimpleType)schemaType);
        }
    }

    private void processAnonymousComplexSchemaType(XmlSchemaElement elt, XmlSchemaComplexType complexType) throws SchemaCompilationException {
        XmlSchemaParticle particle = complexType.getParticle();
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        if (particle != null) {
            this.processParticle(particle, metaInfHolder);
        }
        XmlSchemaObjectCollection attribs = complexType.getAttributes();
        Iterator attribIterator = attribs.getIterator();
        while (attribIterator.hasNext()) {
            Object o = attribIterator.next();
            if (!(o instanceof XmlSchemaAttribute)) continue;
            this.processAttribute((XmlSchemaAttribute)o, metaInfHolder);
        }
        XmlSchemaAnyAttribute anyAtt = complexType.getAnyAttribute();
        if (anyAtt != null) {
            this.processAnyAttribute(metaInfHolder);
        }
        this.processedAnonymousComplexTypesMap.put(elt, metaInfHolder);
    }

    private void processNamedComplexSchemaType(XmlSchemaComplexType complexType) throws SchemaCompilationException {
        if (this.processedTypemap.containsKey(complexType.getQName()) || this.baseSchemaTypeMap.containsKey(complexType.getQName())) {
            return;
        }
        XmlSchemaParticle particle = complexType.getParticle();
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        if (particle != null) {
            this.processParticle(particle, metaInfHolder);
        }
        XmlSchemaObjectCollection attribs = complexType.getAttributes();
        Iterator attribIterator = attribs.getIterator();
        while (attribIterator.hasNext()) {
            Object o = attribIterator.next();
            if (!(o instanceof XmlSchemaAttribute)) continue;
            this.processAttribute((XmlSchemaAttribute)o, metaInfHolder);
        }
        XmlSchemaAnyAttribute anyAtt = complexType.getAnyAttribute();
        if (anyAtt != null) {
            this.processAnyAttribute(metaInfHolder);
        }
        if (complexType.getContentModel() != null) {
            throw new RuntimeException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror"));
        }
        String fullyQualifiedClassName = this.writer.write(complexType, (Map)this.processedTypemap, metaInfHolder);
        this.processedTypemap.put(complexType.getQName(), fullyQualifiedClassName);
    }

    private void processAnyAttribute(BeanWriterMetaInfoHolder metainf) {
        metainf.registerMapping(new QName(EXTRA_ATTRIBUTE_FIELD_NAME), null, (array$Lorg$apache$axis2$om$OMElement == null ? (array$Lorg$apache$axis2$om$OMElement = SchemaCompiler.class$("[Lorg.apache.axis2.om.OMElement;")) : array$Lorg$apache$axis2$om$OMElement).getName(), SchemaConstants.ANY_ATTRIBUTE_TYPE);
    }

    public void processAttribute(XmlSchemaAttribute att, BeanWriterMetaInfoHolder metainf) {
        QName schemaTypeName = att.getSchemaTypeName();
        if (this.baseSchemaTypeMap.containsKey(schemaTypeName)) {
            metainf.registerMapping(att.getQName(), schemaTypeName, this.baseSchemaTypeMap.get(schemaTypeName).toString(), SchemaConstants.ATTRIBUTE_TYPE);
        }
    }

    private void processParticle(XmlSchemaParticle particle, BeanWriterMetaInfoHolder metainfHolder) throws SchemaCompilationException {
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaObjectCollection items = ((XmlSchemaSequence)particle).getItems();
            this.process(items, metainfHolder, true);
        } else if (particle instanceof XmlSchemaAll) {
            XmlSchemaObjectCollection items = ((XmlSchemaAll)particle).getItems();
            this.process(items, metainfHolder, false);
        } else if (particle instanceof XmlSchemaChoice) {
            // empty if block
        }
    }

    private void process(XmlSchemaObjectCollection items, BeanWriterMetaInfoHolder metainfHolder, boolean order) throws SchemaCompilationException {
        int count = items.getCount();
        HashMap<XmlSchemaElement, Boolean> processedElements = new HashMap<XmlSchemaElement, Boolean>();
        HashMap<XmlSchemaElement, Integer> elementOrderMap = new HashMap<XmlSchemaElement, Integer>();
        for (int i = 0; i < count; ++i) {
            XmlSchemaObject item = items.getItem(i);
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement xsElt = (XmlSchemaElement)item;
                boolean isArray = this.isArray((XmlSchemaParticle)xsElt);
                this.processElement(xsElt, false, isArray);
                processedElements.put(xsElt, isArray ? Boolean.TRUE : Boolean.FALSE);
                if (!order) continue;
                elementOrderMap.put(xsElt, new Integer(i));
                continue;
            }
            if (item instanceof XmlSchemaComplexContent) {
                XmlSchemaContent content = ((XmlSchemaComplexContent)item).getContent();
                if (!(content instanceof XmlSchemaComplexContentExtension) && !(content instanceof XmlSchemaComplexContentRestriction)) continue;
            }
            if (!(item instanceof XmlSchemaAny)) continue;
            this.processAny((XmlSchemaAny)item, metainfHolder);
        }
        Iterator processedElementsIterator = processedElements.keySet().iterator();
        while (processedElementsIterator.hasNext()) {
            XmlSchemaElement elt = (XmlSchemaElement)processedElementsIterator.next();
            QName qName = elt.getQName();
            String clazzName = (String)this.processedElementMap.get(qName);
            metainfHolder.registerMapping(qName, elt.getSchemaTypeName(), clazzName, (Boolean)processedElements.get(elt) != false ? SchemaConstants.ANY_ARRAY_TYPE : SchemaConstants.ELEMENT_TYPE);
            metainfHolder.addMaxOccurs(qName, elt.getMaxOccurs());
            metainfHolder.addMinOccurs(qName, elt.getMinOccurs());
            if (!order) continue;
            Integer integer = (Integer)elementOrderMap.get(elt);
            metainfHolder.registerQNameIndex(qName, integer);
        }
        metainfHolder.setOrdered(order);
    }

    private void processAny(XmlSchemaAny any, BeanWriterMetaInfoHolder metainf) {
        metainf.registerMapping(new QName(ANY_ELEMENT_FIELD_NAME), null, (class$org$apache$axis2$om$OMElement == null ? (class$org$apache$axis2$om$OMElement = SchemaCompiler.class$("org.apache.axis2.om.OMElement")) : class$org$apache$axis2$om$OMElement).getName(), SchemaConstants.ANY_TYPE);
    }

    private void processSimpleSchemaType(XmlSchemaElement xsElt, XmlSchemaSimpleType simpleType) {
        XmlSchemaSimpleTypeContent content = simpleType.getContent();
        if (content != null && content instanceof XmlSchemaSimpleTypeRestriction) {
            XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
            QName baseTypeName = restriction.getBaseTypeName();
            if (this.baseSchemaTypeMap.containsKey(baseTypeName)) {
                String className = (String)this.baseSchemaTypeMap.get(baseTypeName);
                this.simpleTypesMap.put(simpleType.getQName(), className);
                this.changedTypeMap.put(simpleType.getQName(), baseTypeName);
            } else if (restriction.getBaseType() != null) {
                this.processSimpleSchemaType(xsElt, restriction.getBaseType());
            }
        }
    }

    private boolean isArray(XmlSchemaParticle particle) throws SchemaCompilationException {
        long minOccurs = particle.getMinOccurs();
        long maxOccurs = particle.getMaxOccurs();
        if (maxOccurs < minOccurs) {
            throw new SchemaCompilationException();
        }
        return maxOccurs > 1L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

