/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.emitter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.URIResolver;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.XSLTUtils;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.writer.AntBuildWriter;
import org.apache.axis2.wsdl.codegen.writer.CallbackHandlerWriter;
import org.apache.axis2.wsdl.codegen.writer.ClassWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceImplementationWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.MessageReceiverWriter;
import org.apache.axis2.wsdl.codegen.writer.ServiceXMLWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonWriter;
import org.apache.axis2.wsdl.codegen.writer.TestClassWriter;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.XSLTIncludeResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wsdl.MessageReference;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLBindingOperation;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.WSDLEndpoint;
import org.apache.wsdl.WSDLExtensibilityAttribute;
import org.apache.wsdl.WSDLExtensibilityElement;
import org.apache.wsdl.WSDLInterface;
import org.apache.wsdl.WSDLOperation;
import org.apache.wsdl.WSDLService;
import org.apache.wsdl.extensions.ExtensionConstants;
import org.apache.wsdl.extensions.SOAPAddress;
import org.apache.wsdl.extensions.SOAPHeader;
import org.apache.wsdl.extensions.SOAPOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class MultiLanguageClientEmitter
implements Emitter {
    private static final String CALL_BACK_HANDLER_SUFFIX = "CallbackHandler";
    private static final String STUB_SUFFIX = "Stub";
    private static final String TEST_SUFFIX = "Test";
    private static final String SERVICE_CLASS_SUFFIX = "Skeleton";
    private static final String MESSAGE_RECEIVER_SUFFIX = "MessageReceiver";
    private static final String DATABINDING_SUPPORTER_NAME_SUFFIX = "DatabindingSupporter";
    private static final String DATABINDING_PACKAGE_NAME_SUFFIX = ".databinding";
    private static HashMap constructorMap = new HashMap(50);
    private Log log = LogFactory.getLog(this.getClass());
    protected InformationHolder infoHolder = null;
    protected CodeGenConfiguration configuration;
    protected TypeMapper mapper;
    protected URIResolver resolver;

    protected void addAttribute(Document document, String AttribName, String attribValue, Element element) {
        XSLTUtils.addAttribute(document, AttribName, attribValue, element);
    }

    protected void addEndpoint(Document doc, Element rootElement) throws Exception {
        WSDLEndpoint endpoint = this.infoHolder.getPort();
        Element endpointElement = doc.createElement("endpoint");
        SOAPAddress address = null;
        Iterator iterator = endpoint.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            WSDLExtensibilityElement element = (WSDLExtensibilityElement)iterator.next();
            if (!ExtensionConstants.SOAP_11_ADDRESS.equals(element.getType()) && !ExtensionConstants.SOAP_12_ADDRESS.equals(element.getType())) continue;
            address = (SOAPAddress)element;
        }
        Text text = doc.createTextNode(address != null ? address.getLocationURI() : "");
        endpointElement.appendChild(text);
        rootElement.appendChild(endpointElement);
    }

    private void addHeaderOperations(List soapHeaderParameterQNameList, WSDLBindingOperation bindingOperation, boolean input) {
        Iterator extIterator;
        if (input) {
            extIterator = bindingOperation.getInput() == null ? null : bindingOperation.getInput().getExtensibilityElements().iterator();
        } else {
            Iterator iterator = extIterator = bindingOperation.getOutput() == null ? null : bindingOperation.getOutput().getExtensibilityElements().iterator();
        }
        while (extIterator != null && extIterator.hasNext()) {
            WSDLExtensibilityElement element = (WSDLExtensibilityElement)extIterator.next();
            if (!ExtensionConstants.SOAP_11_HEADER.equals(element.getType())) continue;
            SOAPHeader header = (SOAPHeader)element;
            soapHeaderParameterQNameList.add(header.getElement());
        }
    }

    private void addSOAPAction(Document doc, Element rootElement, WSDLBindingOperation binding) {
        List extensibilityElements = binding.getExtensibilityElements();
        boolean actionAdded = false;
        if (extensibilityElements != null && !extensibilityElements.isEmpty()) {
            Iterator extIterator = extensibilityElements.iterator();
            while (extIterator.hasNext()) {
                WSDLExtensibilityElement element = (WSDLExtensibilityElement)extIterator.next();
                if (!ExtensionConstants.SOAP_11_OPERATION.equals(element.getType()) && !ExtensionConstants.SOAP_12_OPERATION.equals(element.getType())) continue;
                this.addAttribute(doc, "soapaction", ((SOAPOperation)element).getSoapAction(), rootElement);
                actionAdded = true;
            }
        }
        if (!actionAdded) {
            this.addAttribute(doc, "soapaction", "", rootElement);
        }
    }

    protected void addSoapVersion(WSDLBinding binding, Document doc, Element rootElement) {
        List extensibilityElementsList = binding.getExtensibilityElements();
        int count = extensibilityElementsList.size();
        for (int i = 0; i < count; ++i) {
            WSDLExtensibilityElement extElement = (WSDLExtensibilityElement)extensibilityElementsList.get(i);
            if (ExtensionConstants.SOAP_11_BINDING.equals(extElement.getType())) {
                this.addAttribute(doc, "soap-version", "1.1", rootElement);
                break;
            }
            if (!ExtensionConstants.SOAP_12_BINDING.equals(extElement.getType())) continue;
            this.addAttribute(doc, "soap-version", "1.2", rootElement);
            break;
        }
    }

    protected Document createDOMDocumentForAntBuild() {
        WSDLInterface wsdlInterface = this.infoHolder.getPorttype();
        WSDLService service = this.infoHolder.getService();
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("ant");
        String localPart = this.getCoreClassName(wsdlInterface);
        String packageName = this.configuration.getPackageName();
        String[] dotSeparatedValues = packageName.split("\\.");
        this.addAttribute(doc, "package", dotSeparatedValues[0], rootElement);
        this.addAttribute(doc, "name", localPart, rootElement);
        String servicename = localPart;
        if (service != null) {
            servicename = service.getName().getLocalPart();
        }
        this.addAttribute(doc, "servicename", servicename, rootElement);
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForCallbackHandler() {
        Document doc = this.getEmptyDocument();
        WSDLInterface boundInterface = this.infoHolder.getPorttype();
        WSDLBinding axisBinding = this.infoHolder.getBinding();
        Element rootElement = doc.createElement("callback");
        this.addAttribute(doc, "package", this.configuration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", this.getCoreClassName(boundInterface) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.addAttribute(doc, "namespace", boundInterface.getName().getNamespaceURI(), rootElement);
        this.loadOperations(boundInterface, doc, rootElement, axisBinding);
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForInterface(boolean writeDatabinders) {
        Document doc = this.getEmptyDocument();
        WSDLInterface wsdlInterface = this.infoHolder.getPorttype();
        WSDLBinding axisBinding = this.infoHolder.getBinding();
        Element rootElement = doc.createElement("interface");
        String localPart = this.getCoreClassName(wsdlInterface);
        this.addAttribute(doc, "package", this.configuration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", localPart, rootElement);
        this.addAttribute(doc, "callbackname", wsdlInterface.getName().getLocalPart() + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(wsdlInterface, doc, rootElement, axisBinding);
        if (writeDatabinders && this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForInterfaceImplementation() throws Exception {
        WSDLInterface boundInterface = this.infoHolder.getPorttype();
        WSDLBinding binding = this.infoHolder.getBinding();
        String packageName = this.configuration.getPackageName();
        String localPart = this.getCoreClassName(boundInterface);
        String stubName = localPart + STUB_SUFFIX;
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", packageName, rootElement);
        this.addAttribute(doc, "name", stubName, rootElement);
        this.addAttribute(doc, "servicename", localPart, rootElement);
        this.addAttribute(doc, "namespace", boundInterface.getName().getNamespaceURI(), rootElement);
        this.addAttribute(doc, "interfaceName", localPart, rootElement);
        this.addAttribute(doc, "callbackname", localPart + CALL_BACK_HANDLER_SUFFIX, rootElement);
        if (this.configuration.isPackClasses()) {
            this.addAttribute(doc, "wrapped", "yes", rootElement);
        }
        this.addSoapVersion(binding, doc, rootElement);
        this.addEndpoint(doc, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.loadOperations(boundInterface, doc, rootElement, binding);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, binding));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForServiceXML() {
        WSDLInterface boundInterface = this.infoHolder.getPorttype();
        WSDLBinding axisBinding = this.infoHolder.getBinding();
        WSDLService service = this.infoHolder.getService();
        Document doc = this.getEmptyDocument();
        String coreClassName = this.getCoreClassName(boundInterface);
        if (service != null) {
            doc.appendChild(this.getServiceElement(service.getName().getLocalPart(), coreClassName, doc, boundInterface, axisBinding));
        } else {
            doc.appendChild(this.getServiceElement(boundInterface.getName().getLocalPart(), coreClassName, doc, boundInterface, axisBinding));
        }
        return doc;
    }

    protected Document createDOMDocumentForSkeleton() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        WSDLInterface boundInterface = this.infoHolder.getPorttype();
        WSDLBinding axisBinding = this.infoHolder.getBinding();
        String localpart = this.getCoreClassName(boundInterface);
        this.addAttribute(doc, "package", this.configuration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", localpart + SERVICE_CLASS_SUFFIX, rootElement);
        this.addAttribute(doc, "callbackname", boundInterface.getName().getLocalPart() + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(boundInterface, doc, rootElement, axisBinding);
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForTestCase() {
        WSDLInterface boundInterface = this.infoHolder.getPorttype();
        WSDLBinding binding = this.infoHolder.getBinding();
        String localPart = this.getCoreClassName(boundInterface);
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", this.configuration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", localPart + TEST_SUFFIX, rootElement);
        this.addAttribute(doc, "namespace", boundInterface.getName().getNamespaceURI(), rootElement);
        this.addAttribute(doc, "interfaceName", localPart, rootElement);
        this.addAttribute(doc, "callbackname", localPart + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.addAttribute(doc, "stubname", localPart + STUB_SUFFIX, rootElement);
        this.addAttribute(doc, "dbsupportpackage", this.configuration.getPackageName() + DATABINDING_PACKAGE_NAME_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(boundInterface, doc, rootElement);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, binding));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Element createDOMElementforDatabinders(Document doc, WSDLBinding binding) {
        HashMap bindingOperationsMap = binding.getBindingOperations();
        HashMap<String, Element> parameterMap = new HashMap<String, Element>();
        Iterator operationsIterator = bindingOperationsMap.values().iterator();
        while (operationsIterator.hasNext()) {
            Element newChild;
            int i;
            Element outputParamElement;
            WSDLBindingOperation bindingOperation = (WSDLBindingOperation)operationsIterator.next();
            Element inputParamElement = this.getInputParamElement(doc, bindingOperation.getOperation());
            if (inputParamElement != null) {
                parameterMap.put(inputParamElement.getAttribute("type"), inputParamElement);
            }
            if ((outputParamElement = this.getOutputParamElement(doc, bindingOperation.getOperation())) != null) {
                parameterMap.put(outputParamElement.getAttribute("type"), outputParamElement);
            }
            ArrayList headerParameterQNameList = new ArrayList();
            this.addHeaderOperations(headerParameterQNameList, bindingOperation, true);
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                newChild = (Element)parameterElementList.get(i);
                parameterMap.put(newChild.getAttribute("type"), newChild);
            }
            headerParameterQNameList.clear();
            parameterElementList.clear();
            this.addHeaderOperations(headerParameterQNameList, bindingOperation, false);
            parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                newChild = (Element)parameterElementList.get(i);
                parameterMap.put(newChild.getAttribute("type"), newChild);
            }
        }
        Element rootElement = doc.createElement("databinders");
        this.addAttribute(doc, "dbtype", this.configuration.getDatabindingType(), rootElement);
        rootElement.appendChild(this.getBase64Elements(doc));
        Collection parameters = parameterMap.values();
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            rootElement.appendChild((Element)iterator.next());
        }
        return rootElement;
    }

    protected Document createDocumentForMessageReceiver() {
        WSDLBinding binding = this.infoHolder.getBinding();
        WSDLInterface boundInterface = this.infoHolder.getPorttype();
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", this.configuration.getPackageName(), rootElement);
        String localPart = this.getCoreClassName(boundInterface);
        this.addAttribute(doc, "name", localPart + MESSAGE_RECEIVER_SUFFIX, rootElement);
        this.addAttribute(doc, "skeletonname", localPart + SERVICE_CLASS_SUFFIX, rootElement);
        this.addAttribute(doc, "basereceiver", "org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver", rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.loadOperations(boundInterface, doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, binding));
        doc.appendChild(rootElement);
        return doc;
    }

    public void emitSkeleton() throws CodeGenerationException {
        try {
            int codegenStyle = this.configuration.getCodeGenerationStyle();
            if (codegenStyle == 1) {
                this.emitSkeletonInterface();
            } else if (codegenStyle == 2) {
                this.emitSkeletonBinding();
            } else if (codegenStyle == 0) {
                this.emitSkeletonAutomatic();
            } else {
                throw new Exception(CodegenMessages.getMessage("emitter.unknownStyle", codegenStyle + ""));
            }
            if (this.configuration.isGenerateAll()) {
                this.emitStub();
            }
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private void emitSkeletonAutomatic() throws Exception {
        if (this.infoHolder.getBinding() == null) {
            this.emitSkeletonInterface();
        } else {
            this.emitSkeletonBinding();
        }
    }

    private void emitSkeletonBinding() throws Exception {
        WSDLBinding axisBinding = this.infoHolder.getBinding();
        WSDLInterface wsInterface = this.infoHolder.getPorttype();
        if (axisBinding == null) {
            throw new Exception(CodegenMessages.getMessage("emitter.cannotFindBinding"));
        }
        if (this.mapper.isObjectMappingPresent()) {
            this.updateMapperForMessageReceiver(wsInterface);
        }
        this.writeSkeleton();
        this.writeServiceXml();
        this.writeMessageReceiver();
        if (!this.configuration.isGenerateAll()) {
            this.writeAntBuild();
        }
    }

    private void emitSkeletonInterface() throws Exception {
        this.writeSkeleton();
        this.writeServiceXml();
        this.log.info((Object)CodegenMessages.getMessage("emitter.logEntryInterface1"));
        this.log.info((Object)CodegenMessages.getMessage("emitter.logEntryInterface2"));
    }

    public void emitStub() throws CodeGenerationException {
        block5: {
            try {
                int codegenStyle = this.configuration.getCodeGenerationStyle();
                if (codegenStyle == 1) {
                    this.emitStubInterface();
                    break block5;
                }
                if (codegenStyle == 2) {
                    this.emitStubBinding();
                    break block5;
                }
                if (codegenStyle == 0) {
                    this.emitStubAutomatic();
                    break block5;
                }
                throw new Exception(CodegenMessages.getMessage("emitter.unknownStyle", codegenStyle + ""));
            }
            catch (Exception e) {
                throw new CodeGenerationException(e);
            }
        }
    }

    private void emitStubAutomatic() throws Exception {
        if (this.infoHolder.getBinding() == null) {
            this.emitStubInterface();
        } else {
            this.emitStubBinding();
        }
    }

    private void emitStubBinding() throws Exception {
        WSDLInterface axisInterface = this.infoHolder.getPorttype();
        if (this.mapper.isObjectMappingPresent()) {
            this.updateMapperForStub(axisInterface);
        }
        if (!this.configuration.isPackClasses()) {
            this.writeInterface(false);
        }
        this.writeCallBackHandlers();
        this.writeInterfaceImplementation();
        this.writeTestClasses();
        this.writeAntBuild();
    }

    private void emitStubInterface() throws Exception {
        WSDLInterface axisInterface = this.infoHolder.getPorttype();
        if (this.mapper.isObjectMappingPresent()) {
            this.updateMapperForInterface(axisInterface);
        }
        this.writeInterface(true);
        this.writeCallBackHandlers();
        this.log.info((Object)CodegenMessages.getMessage("emitter.logEntryInterface1"));
        this.log.info((Object)CodegenMessages.getMessage("emitter.logEntryInterface3"));
        this.log.info((Object)CodegenMessages.getMessage("emitter.logEntryInterface4"));
        this.log.info((Object)CodegenMessages.getMessage("emitter.logEntryInterface5"));
        this.log.info((Object)CodegenMessages.getMessage("emitter.logEntryInterface6"));
    }

    private void fillSyncAttributes(Document doc, Element rootElement) {
        this.addAttribute(doc, "isAsync", this.configuration.isAsyncOn() ? "1" : "0", rootElement);
        this.addAttribute(doc, "isSync", this.configuration.isSyncOn() ? "1" : "0", rootElement);
    }

    private void loadOperations(WSDLInterface boundInterface, Document doc, Element rootElement) {
        this.loadOperations(boundInterface, doc, rootElement, null);
    }

    private void loadOperations(WSDLInterface boundInterface, Document doc, Element rootElement, WSDLBinding binding) {
        Collection col = boundInterface.getOperations().values();
        String portTypeName = this.getCoreClassName(boundInterface);
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            WSDLBindingOperation bindingOperation;
            ArrayList soapHeaderInputParameterList = new ArrayList();
            ArrayList soapHeaderOutputParameterList = new ArrayList();
            WSDLOperation operation = (WSDLOperation)iterator.next();
            Element methodElement = doc.createElement("method");
            String localPart = operation.getName().getLocalPart();
            this.addAttribute(doc, "name", localPart, methodElement);
            this.addAttribute(doc, "namespace", operation.getName().getNamespaceURI(), methodElement);
            this.addAttribute(doc, "style", operation.getStyle(), methodElement);
            this.addAttribute(doc, "dbsupportname", portTypeName + localPart + DATABINDING_SUPPORTER_NAME_SUFFIX, methodElement);
            this.addAttribute(doc, "mep", operation.getMessageExchangePattern(), methodElement);
            if (null != binding && (bindingOperation = binding.getBindingOperation(operation.getName())) != null) {
                this.addSOAPAction(doc, methodElement, bindingOperation);
                this.addHeaderOperations(soapHeaderInputParameterList, bindingOperation, true);
                this.addHeaderOperations(soapHeaderOutputParameterList, bindingOperation, false);
            }
            methodElement.appendChild(this.getInputElement(doc, operation, soapHeaderInputParameterList));
            methodElement.appendChild(this.getOutputElement(doc, operation, soapHeaderOutputParameterList));
            rootElement.appendChild(methodElement);
        }
    }

    protected String makeJavaClassName(String word) {
        if (JavaUtils.isJavaKeyword((String)word)) {
            return JavaUtils.makeNonJavaKeyword((String)word);
        }
        return JavaUtils.capitalizeFirstChar((String)JavaUtils.xmlNameToJava((String)word));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateInformationHolder() {
        this.infoHolder = new InformationHolder();
        WSDLDescription wsdlDescription = this.configuration.getWom();
        int codegenStyle = this.configuration.getCodeGenerationStyle();
        if (codegenStyle == 1) {
            this.populatePorttype(this.infoHolder, wsdlDescription);
            return;
        }
        Map services = wsdlDescription.getServices();
        if (services != null && !services.isEmpty()) {
            WSDLEndpoint selectedEndpoint;
            WSDLService selectedService;
            if (services.size() > 1) {
                if (this.configuration.getServiceName() != null) {
                    selectedService = wsdlDescription.getService(new QName(this.configuration.getWom().getTargetNameSpace(), this.configuration.getServiceName()));
                    if (selectedService == null) {
                        throw new RuntimeException(CodegenMessages.getMessage("emitter.serviceNotFoundError", this.configuration.getServiceName()));
                    }
                } else {
                    System.out.println(CodegenMessages.getMessage("emitter.warningMultipleServices"));
                    selectedService = (WSDLService)services.values().iterator().next();
                }
            } else {
                selectedService = (WSDLService)services.values().iterator().next();
            }
            this.infoHolder.setService(selectedService);
            HashMap endpoints = selectedService.getEndpoints();
            if (endpoints == null || endpoints.isEmpty()) throw new RuntimeException(CodegenMessages.getMessage("emitter.noEndpointsFoundError"));
            if (endpoints.size() > 1) {
                if (this.configuration.getPortName() != null) {
                    selectedEndpoint = selectedService.getEndpoint(new QName(this.configuration.getWom().getTargetNameSpace(), this.configuration.getPortName()));
                    if (selectedEndpoint == null) {
                        throw new RuntimeException(CodegenMessages.getMessage("emitter.endpointNotFoundError"));
                    }
                } else {
                    System.out.println(CodegenMessages.getMessage("emitter.warningMultipleEndpoints"));
                    selectedEndpoint = (WSDLEndpoint)endpoints.values().iterator().next();
                }
            } else {
                selectedEndpoint = (WSDLEndpoint)endpoints.values().iterator().next();
            }
            this.infoHolder.setPort(selectedEndpoint);
            WSDLBinding binding = selectedEndpoint.getBinding();
            this.infoHolder.setBinding(binding);
            this.infoHolder.setPorttype(binding.getBoundInterface());
            return;
        } else {
            System.out.println(CodegenMessages.getMessage("emitter.switchingMessages"));
            this.populatePorttype(this.infoHolder, wsdlDescription);
        }
    }

    private void populatePorttype(InformationHolder info, WSDLDescription description) {
        Map wsdlInterfaces = description.getWsdlInterfaces();
        if (wsdlInterfaces != null && !wsdlInterfaces.isEmpty()) {
            if (wsdlInterfaces.size() > 1) {
                System.out.println(CodegenMessages.getMessage("emitter.warningMultiplePorttypes"));
            }
            Iterator porttypeIterator = wsdlInterfaces.values().iterator();
            info.setPorttype((WSDLInterface)porttypeIterator.next());
        }
    }

    private void processModelObjects(Map objectMappings, Element root, Document doc) {
        Iterator objectIterator = objectMappings.values().iterator();
        while (objectIterator.hasNext()) {
            Object o = objectIterator.next();
            if (!(o instanceof Document)) continue;
            root.appendChild(doc.importNode(((Document)o).getDocumentElement(), true));
        }
    }

    private void updateMapperClassnames(String fullyQulifiedIncludingClassNamePrefix) {
        Map classNameMap = this.mapper.getAllMappedNames();
        Iterator keys = classNameMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            classNameMap.put(key, fullyQulifiedIncludingClassNamePrefix + classNameMap.get(key));
        }
    }

    private void updateMapperForInterface(WSDLInterface boundInterface) {
        String packageName = this.configuration.getPackageName();
        String interfaceName = this.getCoreClassName(boundInterface);
        this.updateMapperClassnames(packageName + "." + interfaceName + ".");
    }

    private void updateMapperForMessageReceiver(WSDLInterface boundInterface) {
        String packageName = this.configuration.getPackageName();
        String localPart = this.getCoreClassName(boundInterface);
        String messageReceiver = localPart + MESSAGE_RECEIVER_SUFFIX;
        this.updateMapperClassnames(packageName + "." + messageReceiver + ".");
    }

    private void updateMapperForStub(WSDLInterface boundInterface) {
        String packageName = this.configuration.getPackageName();
        String localPart = this.getCoreClassName(boundInterface);
        String stubName = localPart + STUB_SUFFIX;
        this.updateMapperClassnames(packageName + "." + stubName + ".");
    }

    protected void writeAntBuild() throws Exception {
        Document skeletonModel = this.createDOMDocumentForAntBuild();
        AntBuildWriter antBuildWriter = new AntBuildWriter(this.configuration.getOutputLocation(), this.configuration.getOutputLanguage());
        antBuildWriter.setDatabindingFramework(this.configuration.getDatabindingType());
        this.writeClass(skeletonModel, antBuildWriter);
    }

    protected void writeCallBackHandlers() throws Exception {
        if (this.configuration.isAsyncOn()) {
            Document interfaceModel = this.createDOMDocumentForCallbackHandler();
            CallbackHandlerWriter callbackWriter = new CallbackHandlerWriter(this.getOutputDirectory(this.configuration.getOutputLocation(), "src"), this.configuration.getOutputLanguage());
            this.writeClass(interfaceModel, callbackWriter);
        }
    }

    protected void writeClass(Document model, ClassWriter writer) throws IOException, Exception {
        writer.loadTemplate();
        String packageName = model.getDocumentElement().getAttribute("package");
        String className = model.getDocumentElement().getAttribute("name");
        writer.createOutFile(packageName, className);
        writer.parse(model, this.resolver);
    }

    protected void writeInterface(boolean writeDatabinders) throws Exception {
        Document interfaceModel = this.createDOMDocumentForInterface(writeDatabinders);
        InterfaceWriter interfaceWriter = new InterfaceWriter(this.getOutputDirectory(this.configuration.getOutputLocation(), "src"), this.configuration.getOutputLanguage());
        this.writeClass(interfaceModel, interfaceWriter);
    }

    protected void writeInterfaceImplementation() throws Exception {
        Document interfaceImplModel = this.createDOMDocumentForInterfaceImplementation();
        InterfaceImplementationWriter writer = new InterfaceImplementationWriter(this.getOutputDirectory(this.configuration.getOutputLocation(), "src"), this.configuration.getOutputLanguage());
        this.writeClass(interfaceImplModel, writer);
    }

    protected void writeMessageReceiver() throws Exception {
        if (this.configuration.isWriteMessageReceiver()) {
            Document classModel = this.createDocumentForMessageReceiver();
            MessageReceiverWriter writer = new MessageReceiverWriter(this.getOutputDirectory(this.configuration.getOutputLocation(), "src"), this.configuration.getOutputLanguage());
            this.writeClass(classModel, writer);
        }
    }

    protected void writeServiceXml() throws Exception {
        if (this.configuration.isGenerateDeployementDescriptor()) {
            Document serviceXMLModel = this.createDOMDocumentForServiceXML();
            ServiceXMLWriter serviceXmlWriter = new ServiceXMLWriter(this.getOutputDirectory(this.configuration.getOutputLocation(), "resources"), this.configuration.getOutputLanguage());
            this.writeClass(serviceXMLModel, serviceXmlWriter);
        }
    }

    protected void writeSkeleton() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeleton();
        SkeletonWriter skeletonWriter = new SkeletonWriter(this.getOutputDirectory(this.configuration.getOutputLocation(), "src"), this.configuration.getOutputLanguage());
        this.writeClass(skeletonModel, skeletonWriter);
    }

    protected void writeTestClasses() throws Exception {
        if (this.configuration.isWriteTestCase()) {
            Document classModel = this.createDOMDocumentForTestCase();
            TestClassWriter callbackWriter = new TestClassWriter(this.getOutputDirectory(this.configuration.getOutputLocation(), "test"), this.configuration.getOutputLanguage());
            this.writeClass(classModel, callbackWriter);
        }
    }

    private Element getBase64Elements(Document doc) {
        Element root = doc.createElement("base64Elements");
        List list = (List)this.configuration.getProperties().get("base64map");
        if (list != null && !list.isEmpty()) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                QName qname = (QName)list.get(i);
                Element elt = doc.createElement("name");
                this.addAttribute(doc, "ns-url", qname.getNamespaceURI(), elt);
                this.addAttribute(doc, "localName", qname.getLocalPart(), elt);
                root.appendChild(elt);
            }
        }
        return root;
    }

    private String getCoreClassName(WSDLInterface wsInterface) {
        if (wsInterface != null) {
            return this.makeJavaClassName(wsInterface.getName().getLocalPart());
        }
        throw new RuntimeException(CodegenMessages.getMessage("emitter.coreclassNameError"));
    }

    private Document getEmptyDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element getInputElement(Document doc, WSDLOperation operation, List headerParameterQNameList) {
        Element inputElt = doc.createElement("input");
        Element param = this.getInputParamElement(doc, operation);
        if (param != null) {
            inputElt.appendChild(param);
        }
        List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
        for (int i = 0; i < parameterElementList.size(); ++i) {
            inputElt.appendChild((Element)parameterElementList.get(i));
        }
        return inputElt;
    }

    private Element getInputParamElement(Document doc, WSDLOperation operation) {
        Element param = doc.createElement("param");
        MessageReference inputMessage = operation.getInputMessage();
        if (inputMessage != null) {
            this.addAttribute(doc, "name", this.mapper.getParameterName(inputMessage.getElementQName()), param);
            String typeMapping = this.mapper.getTypeMappingName(inputMessage.getElementQName());
            this.addAttribute(doc, "type", typeMapping == null ? "" : typeMapping, param);
            if (TypeMapper.DEFAULT_CLASS_NAME.equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", param);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), param);
            this.addAttribute(doc, "location", "body", param);
            Iterator iter = inputMessage.getExtensibilityAttributes().iterator();
            while (iter.hasNext()) {
                WSDLExtensibilityAttribute att = (WSDLExtensibilityAttribute)iter.next();
                this.addAttribute(doc, att.getKey().getLocalPart(), att.getValue().toString(), param);
            }
        } else {
            param = null;
        }
        return param;
    }

    protected File getOutputDirectory(File outputDir, String dir2) {
        if (!(outputDir = new File(outputDir, dir2)).exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    protected Element getOutputElement(Document doc, WSDLOperation operation, List headerParameterQNameList) {
        Element outputElt = doc.createElement("output");
        Element param = this.getOutputParamElement(doc, operation);
        if (param != null) {
            outputElt.appendChild(param);
        }
        List outputElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
        for (int i = 0; i < outputElementList.size(); ++i) {
            outputElt.appendChild((Element)outputElementList.get(i));
        }
        return outputElt;
    }

    private Element getOutputParamElement(Document doc, WSDLOperation operation) {
        String typeMappingStr;
        String parameterName;
        Element param = doc.createElement("param");
        MessageReference outputMessage = operation.getOutputMessage();
        if (outputMessage != null) {
            parameterName = this.mapper.getParameterName(outputMessage.getElementQName());
            String typeMapping = this.mapper.getTypeMappingName(operation.getOutputMessage().getElementQName());
            typeMappingStr = typeMapping == null ? "" : typeMapping;
        } else {
            parameterName = "";
            typeMappingStr = "";
        }
        this.addAttribute(doc, "name", parameterName, param);
        this.addAttribute(doc, "type", typeMappingStr, param);
        if (TypeMapper.DEFAULT_CLASS_NAME.equals(typeMappingStr)) {
            this.addAttribute(doc, "default", "yes", param);
        }
        this.addAttribute(doc, "location", "body", param);
        return param;
    }

    String getParamInitializer(String paramType) {
        String out = (String)constructorMap.get(paramType);
        if (out == null) {
            out = "null";
        }
        return out;
    }

    private List getParameterElementList(Document doc, List parameters, String location) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                QName name = (QName)parameters.get(i);
                this.addAttribute(doc, "name", this.mapper.getParameterName(name), param);
                String typeMapping = this.mapper.getTypeMappingName(name);
                String typeMappingStr = typeMapping == null ? "" : typeMapping;
                this.addAttribute(doc, "type", typeMappingStr, param);
                this.addAttribute(doc, "location", location, param);
                parameterElementList.add(param);
            }
        }
        return parameterElementList;
    }

    private Element getServiceElement(String serviceName, String porttypeName, Document doc, WSDLInterface boundInterface, WSDLBinding axisBinding) {
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", "", rootElement);
        this.addAttribute(doc, "classpackage", this.configuration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", porttypeName + SERVICE_CLASS_SUFFIX, rootElement);
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        this.addAttribute(doc, "messagereceiver", porttypeName + MESSAGE_RECEIVER_SUFFIX, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(boundInterface, doc, rootElement, axisBinding);
        return rootElement;
    }

    public void setCodeGenConfiguration(CodeGenConfiguration configuration) {
        this.configuration = configuration;
        this.resolver = new XSLTIncludeResolver(this.configuration.getProperties());
        this.populateInformationHolder();
    }

    public void setMapper(TypeMapper mapper) {
        this.mapper = mapper;
    }

    static {
        constructorMap.put("int", "0");
        constructorMap.put("float", "0");
        constructorMap.put("boolean", "true");
        constructorMap.put("double", "0");
        constructorMap.put("byte", "(byte)0");
        constructorMap.put("short", "(short)0");
        constructorMap.put("long", "0");
        constructorMap.put("java.lang.Boolean", "new java.lang.Boolean(false)");
        constructorMap.put("java.lang.Byte", "new java.lang.Byte((byte)0)");
        constructorMap.put("java.lang.Double", "new java.lang.Double(0)");
        constructorMap.put("java.lang.Float", "new java.lang.Float(0)");
        constructorMap.put("java.lang.Integer", "new java.lang.Integer(0)");
        constructorMap.put("java.lang.Long", "new java.lang.Long(0)");
        constructorMap.put("java.lang.Short", "new java.lang.Short((short)0)");
        constructorMap.put("java.math.BigDecimal", "new java.math.BigDecimal(0)");
        constructorMap.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        constructorMap.put("java.lang.Object", "new java.lang.String()");
        constructorMap.put("byte[]", "new byte[0]");
        constructorMap.put("java.util.Calendar", "java.util.Calendar.getInstance()");
        constructorMap.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"http://double-double\", \"toil-and-trouble\")");
    }

    private class InformationHolder {
        private WSDLBinding binding;
        private WSDLEndpoint port;
        private WSDLInterface porttype;
        private WSDLService service;

        private InformationHolder() {
        }

        public WSDLBinding getBinding() {
            return this.binding;
        }

        public WSDLEndpoint getPort() {
            return this.port;
        }

        public WSDLInterface getPorttype() {
            return this.porttype;
        }

        public WSDLService getService() {
            return this.service;
        }

        public void setBinding(WSDLBinding binding) {
            this.binding = binding;
        }

        public void setPort(WSDLEndpoint port) {
            this.port = port;
        }

        public void setPorttype(WSDLInterface porttype) {
            this.porttype = porttype;
        }

        public void setService(WSDLService service) {
            this.service = service;
        }
    }
}

