/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.wsdl.util.CommandLineOption;
import org.apache.axis2.wsdl.util.CommandLineOptionConstants;
import org.apache.axis2.wsdl.util.OptionValidator;

public class CommandLineOptionParser
implements CommandLineOptionConstants {
    private Map commandLineOptions;

    public CommandLineOptionParser(Map commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
    }

    public CommandLineOptionParser(String[] args) {
        this.commandLineOptions = this.parse(args);
    }

    private Map parse(String[] args) {
        CommandLineOption commandLineOption;
        HashMap<String, CommandLineOption> commandLineOptions = new HashMap<String, CommandLineOption>();
        if (0 == args.length) {
            return commandLineOptions;
        }
        int state = 0;
        ArrayList<String> optionBundle = null;
        String optionType = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].substring(0, 1).equals("-")) {
                if (0 == state) {
                    state = 1;
                    optionType = args[i];
                    continue;
                }
                if (2 != state && 1 != state) continue;
                commandLineOption = new CommandLineOption(optionType, optionBundle);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                state = 1;
                optionType = args[i];
                optionBundle = null;
                continue;
            }
            if (0 == state) {
                commandLineOption = new CommandLineOption("SOLE_INPUT", args);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                return commandLineOptions;
            }
            if (1 == state) {
                optionBundle = new ArrayList<String>();
                optionBundle.add(args[i]);
                state = 2;
                continue;
            }
            if (2 != state) continue;
            optionBundle.add(args[i]);
        }
        commandLineOption = new CommandLineOption(optionType, optionBundle);
        commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
        return commandLineOptions;
    }

    public Map getAllOptions() {
        return this.commandLineOptions;
    }

    public List getInvalidOptions() {
        ArrayList<CommandLineOption> faultList = new ArrayList<CommandLineOption>();
        Iterator iterator = this.commandLineOptions.values().iterator();
        while (iterator.hasNext()) {
            CommandLineOption commandLineOption = (CommandLineOption)iterator.next();
            if (!OptionValidator.isInvalid(commandLineOption)) continue;
            faultList.add(commandLineOption);
        }
        return faultList;
    }
}

