/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.axis2.wsdl.util.XSLTConstants;

public class XSLTIncludeResolver
implements URIResolver,
XSLTConstants {
    private Map externalPropertyMap;

    public XSLTIncludeResolver() {
    }

    public XSLTIncludeResolver(Map externalPropertyMap) {
        this.externalPropertyMap = externalPropertyMap;
    }

    public void setExternalPropertyMap(Map externalPropertyMap) {
        this.externalPropertyMap = externalPropertyMap;
    }

    public Source resolve(String href, String base) throws TransformerException {
        String templateName;
        if ("databindsupporter".equals(href)) {
            return this.getSourceFromTemplateName(ConfigPropertyFileLoader.getDbSupporterTemplateName());
        }
        if ("testObject".equals(href)) {
            return this.getSourceFromTemplateName(ConfigPropertyFileLoader.getTestObjectTemplateName());
        }
        if (this.externalPropertyMap.get(href) != null && (templateName = this.externalPropertyMap.get(href).toString()) != null) {
            InputStream supporterTemplateStream = this.getClass().getResourceAsStream(templateName);
            return new StreamSource(supporterTemplateStream);
        }
        return this.getEmptySource();
    }

    private Source getSourceFromTemplateName(String templateName) throws TransformerException {
        if (templateName != null) {
            InputStream supporterTemplateStream = this.getClass().getResourceAsStream(templateName);
            return new StreamSource(supporterTemplateStream);
        }
        throw new TransformerException(CodegenMessages.getMessage("reslover.templateNotFound", templateName));
    }

    private Source getEmptySource() {
        return new StreamSource(new ByteArrayInputStream("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"/>".getBytes()));
    }
}

