/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.time.TimeCounterTestHelper;
import barsuift.simLife.time.UniverseTimeController;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import junit.framework.TestCase;

public class UniverseControllerTest
extends TestCase {
    private UniverseTimeController controller;
    private MockUniverse mockUniverse;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockUniverse = new MockUniverse();
        this.controller = new UniverseTimeController((Universe)this.mockUniverse);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.controller = null;
        this.mockUniverse = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStart() {
        UniverseControllerTest.assertFalse((boolean)this.controller.isRunning());
        TimeCounterTestHelper.assertEquals(0, 0, 0, 0, this.controller.getTimeCounter());
        this.controller.start();
        try {
            UniverseControllerTest universeControllerTest = this;
            synchronized (universeControllerTest) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        UniverseControllerTest.assertTrue((this.mockUniverse.getNbTimeSpent() >= 2 ? 1 : 0) != 0);
        UniverseControllerTest.assertTrue((boolean)this.controller.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPause() {
        this.controller.start();
        UniverseControllerTest.assertTrue((boolean)this.controller.isRunning());
        try {
            UniverseControllerTest universeControllerTest = this;
            synchronized (universeControllerTest) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int nbTimeSpent1 = this.mockUniverse.getNbTimeSpent();
        this.controller.pause();
        try {
            UniverseControllerTest universeControllerTest = this;
            synchronized (universeControllerTest) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int nbTimeSpent2 = this.mockUniverse.getNbTimeSpent();
        UniverseControllerTest.assertTrue((nbTimeSpent2 <= nbTimeSpent1 + 1 ? 1 : 0) != 0);
        UniverseControllerTest.assertTrue((nbTimeSpent2 >= nbTimeSpent1 ? 1 : 0) != 0);
        UniverseControllerTest.assertFalse((boolean)this.controller.isRunning());
        try {
            UniverseControllerTest universeControllerTest = this;
            synchronized (universeControllerTest) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int nbTimeSpent3 = this.mockUniverse.getNbTimeSpent();
        UniverseControllerTest.assertEquals((String)"the counter should not increment anymore", (int)nbTimeSpent2, (int)nbTimeSpent3);
        this.controller.start();
        try {
            UniverseControllerTest universeControllerTest = this;
            synchronized (universeControllerTest) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int nbTimeSpent4 = this.mockUniverse.getNbTimeSpent();
        UniverseControllerTest.assertTrue((nbTimeSpent4 >= nbTimeSpent3 + 2 ? 1 : 0) != 0);
        UniverseControllerTest.assertTrue((boolean)this.controller.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIllegalStateException() {
        try {
            this.controller.pause();
            UniverseControllerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.controller.start();
        try {
            UniverseControllerTest ise = this;
            synchronized (ise) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.controller.start();
            UniverseControllerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.controller.oneStep();
            UniverseControllerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneStep() {
        this.controller.oneStep();
        UniverseControllerTest.assertEquals((int)1, (int)this.mockUniverse.getNbTimeSpent());
        try {
            UniverseControllerTest universeControllerTest = this;
            synchronized (universeControllerTest) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        UniverseControllerTest.assertEquals((int)1, (int)this.mockUniverse.getNbTimeSpent());
    }
}

