/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.environment.EnvironmentState;
import barsuift.simLife.time.TimeCounterState;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeState;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class UniverseState {
    private Long id;
    private int age;
    private Set<TreeState> trees;
    private Set<TreeLeafState> fallenLeaves;
    private EnvironmentState environment;
    private TimeCounterState timeCounter;

    public UniverseState() {
        this.id = new Long(0L);
        this.age = 0;
        this.trees = new HashSet<TreeState>();
        this.fallenLeaves = new HashSet<TreeLeafState>();
        this.environment = new EnvironmentState();
        this.timeCounter = new TimeCounterState();
    }

    public UniverseState(Long id, int age, Set<TreeState> trees, Set<TreeLeafState> fallenLeaves, EnvironmentState environment, TimeCounterState timeCounter) {
        this.id = id;
        this.age = age;
        this.trees = trees;
        this.fallenLeaves = fallenLeaves;
        this.environment = environment;
        this.timeCounter = timeCounter;
    }

    public UniverseState(UniverseState copy) {
        this.id = copy.id;
        this.age = copy.age;
        this.trees = new HashSet<TreeState>();
        for (TreeState treeState : copy.trees) {
            this.trees.add(new TreeState(treeState));
        }
        this.fallenLeaves = new HashSet<TreeLeafState>();
        for (TreeLeafState treeLeafState : copy.fallenLeaves) {
            this.fallenLeaves.add(new TreeLeafState(treeLeafState));
        }
        this.environment = new EnvironmentState(copy.environment);
        this.timeCounter = copy.timeCounter;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Set<TreeState> getTrees() {
        return this.trees;
    }

    public void setTrees(Set<TreeState> trees) {
        this.trees = trees;
    }

    public Set<TreeLeafState> getFallenLeaves() {
        return this.fallenLeaves;
    }

    public void setFallenLeaves(Set<TreeLeafState> fallenLeaves) {
        this.fallenLeaves = fallenLeaves;
    }

    public EnvironmentState getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentState environment) {
        this.environment = environment;
    }

    public TimeCounterState getTimeCounter() {
        return this.timeCounter;
    }

    public void setTimeCounter(TimeCounterState timeCounter) {
        this.timeCounter = timeCounter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.timeCounter == null ? 0 : this.timeCounter.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 + this.age;
        result = 31 * result + (this.trees == null ? 0 : ((Object)this.trees).hashCode());
        result = 31 * result + (this.fallenLeaves == null ? 0 : ((Object)this.fallenLeaves).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniverseState other = (UniverseState)obj;
        if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
            return false;
        }
        if (this.timeCounter == null ? other.timeCounter != null : !this.timeCounter.equals(other.timeCounter)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.age != other.age) {
            return false;
        }
        if (this.trees == null ? other.trees != null : !((Object)this.trees).equals(other.trees)) {
            return false;
        }
        return !(this.fallenLeaves == null ? other.fallenLeaves != null : !((Object)this.fallenLeaves).equals(other.fallenLeaves));
    }

    public String toString() {
        return "UniverseState [environment=" + this.environment + ", timeCounter=" + this.timeCounter + ", id=" + this.id + ", age=" + this.age + ", trees=" + this.trees + ", fallenLeaves=" + this.fallenLeaves + "]";
    }
}

