/*
 * Decompiled with CFR 0.152.
 */
package bayern.steinbrecher.utility;

import java.util.stream.Stream;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.NumberExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;

public final class BindingUtility {
    public static final NumberBinding ZERO_BINDING = new IntegerBinding(){

        protected int computeValue() {
            return 0;
        }
    };
    public static final BooleanBinding FALSE_BINDING = new BooleanBinding(){

        protected boolean computeValue() {
            return false;
        }
    };
    public static final BooleanBinding TRUE_BINDING = new BooleanBinding(){

        protected boolean computeValue() {
            return true;
        }
    };

    private BindingUtility() {
        throw new UnsupportedOperationException("Construction of an objection not allowed.");
    }

    public static NumberBinding reduceSum(Stream<? extends ObservableNumberValue> observableValues) {
        return observableValues.reduce(ZERO_BINDING, NumberExpression::add, NumberExpression::add);
    }

    public static BooleanBinding reduceOr(Stream<? extends ObservableBooleanValue> observableValues) {
        return observableValues.reduce(FALSE_BINDING, BooleanExpression::or, BooleanExpression::or);
    }

    public static BooleanBinding reduceAnd(Stream<? extends ObservableBooleanValue> observableValues) {
        return observableValues.reduce(TRUE_BINDING, BooleanExpression::and, BooleanExpression::and);
    }
}

