/*
 * Decompiled with CFR 0.152.
 */
package bayern.steinbrecher.utility;

import bayern.steinbrecher.utility.XMLUtility;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public final class SepaUtility {
    public static final int UNIQUE_DAYS_MESSAGEID = 15;
    public static final int MAX_CHAR_MESSAGE_ID = 35;
    public static final int UNIQUE_MONTH_PMTINFID = 3;
    public static final int MAX_CHAR_PMTINFID = 35;
    public static final int MAX_CHAR_IBAN = 34;
    public static final int MAX_CHAR_NAME_FIELD = 70;
    private static final int SEPA_CC_LENGTH = 2;
    private static final int SEPA_CC_CHECKSUM_LENGTH = 4;
    private static final int SEPA_MIN_LENGTH = 5;
    private static final String SEPA_BUSINESS_CODE = "ZZZ";
    private static final int SEPA_SHIFT_CC = 10;
    private static final int IBAN_CHECKSUM_MODULO = 97;
    public static final String IBAN_REGEX = "[A-Z]{2}\\d{2,32}";
    private static final Pattern IBAN_PATTERN = Pattern.compile("[A-Z]{2}\\d{2,32}");
    public static final String BIC_REGEX = "[A-Z]{6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3})?";
    private static final Pattern BIC_PATTERN = Pattern.compile("[A-Z]{6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3})?");
    public static final String MESSAGE_ID_REGEX = "([a-zA-Z0-9]|/| |-|\\?|:|\\(|\\)|\\.|,|'|\\+)*";
    private static final Pattern MESSAGE_ID_PATTERN = Pattern.compile("([a-zA-Z0-9]|/| |-|\\?|:|\\(|\\)|\\.|,|'|\\+)*");
    private static final URL SEPA_XSD_SCHEMA = SepaUtility.class.getResource("pain.008.003.02.xsd");

    private SepaUtility() {
        throw new UnsupportedOperationException("Construction of an object no allowed.");
    }

    public static boolean isValidIban(String iban) {
        Object trimmedIban;
        boolean isValid = false;
        if (iban != null && !iban.isEmpty() && IBAN_PATTERN.matcher((CharSequence)(trimmedIban = iban.replace(" ", ""))).matches()) {
            int posAlphabetFirstChar = ((String)trimmedIban).charAt(0) - 65 + 10;
            int posAlphabetSecondChar = ((String)trimmedIban).charAt(1) - 65 + 10;
            if (((String)trimmedIban).length() >= 5 && posAlphabetFirstChar >= 10 && posAlphabetSecondChar >= 10) {
                trimmedIban = ((String)trimmedIban).substring(4) + posAlphabetFirstChar + posAlphabetSecondChar + ((String)trimmedIban).substring(2, 4);
                isValid = new BigInteger((String)trimmedIban).mod(BigInteger.valueOf(97L)).equals(BigInteger.ONE);
            }
        }
        return isValid;
    }

    public static boolean isValidBic(String bic) {
        return bic != null && BIC_PATTERN.matcher(bic).matches();
    }

    public static boolean isValidCreditorId(String creditorId) {
        String trimmedCreditorId;
        boolean isValid = creditorId == null ? false : (trimmedCreditorId = creditorId.replaceAll(" ", "")).contains(SEPA_BUSINESS_CODE) && SepaUtility.isValidIban(trimmedCreditorId.replace(SEPA_BUSINESS_CODE, ""));
        return isValid;
    }

    public static boolean isValidMessageId(String messageId) {
        return messageId != null && MESSAGE_ID_PATTERN.matcher(messageId).matches() && messageId.length() <= 35;
    }

    public static String getSepaDate(LocalDateTime dateTime) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime);
    }

    public static String getSepaDate(LocalDate date) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    public static Optional<String> validateSepaXML(String xml) throws SAXException, IOException {
        return XMLUtility.isValidXML(xml, SEPA_XSD_SCHEMA);
    }
}

