/*
 * Decompiled with CFR 0.152.
 */
package bayern.steinbrecher.utility;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;

public class SupplyingMap<K, V>
extends HashMap<K, V> {
    private final Function<K, V> entrySupplier;

    public SupplyingMap(Function<K, V> entrySupplier) {
        this.entrySupplier = Objects.requireNonNull(entrySupplier, "The function generating empty entries must not be null.");
    }

    @Override
    public V get(Object key) {
        if (!this.containsKey(key)) {
            Object keyK = key;
            this.put(keyK, this.entrySupplier.apply(keyK));
        }
        return super.get(key);
    }

    public Function<K, V> getEntrySupplier() {
        return this.entrySupplier;
    }
}

