/*
 * Decompiled with CFR 0.152.
 */
package bayern.steinbrecher.utility;

import bayern.steinbrecher.utility.SupplyingMap;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLUtility {
    private static final Logger LOGGER = Logger.getLogger(XMLUtility.class.getName());

    private XMLUtility() {
        throw new UnsupportedOperationException("Construction of an object is not allowed.");
    }

    public static Optional<String> isValidXML(String xml, URL schema) throws SAXException, IOException {
        Optional<String> validationResult;
        DocumentBuilder xmlBuilder;
        DocumentBuilderFactory xmlBuilderFactory = DocumentBuilderFactory.newInstance();
        xmlBuilderFactory.setIgnoringComments(true);
        xmlBuilderFactory.setNamespaceAware(true);
        xmlBuilderFactory.setValidating(false);
        try {
            xmlBuilder = xmlBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new AssertionError("The DocumentBuilder used for the XML validation is invalid.", ex);
        }
        final SupplyingMap<String, List> validationProblemsMap = new SupplyingMap<String, List>(key -> new ArrayList());
        SimpleBooleanProperty isValidXML = new SimpleBooleanProperty(true);
        xmlBuilder.setErrorHandler(new ErrorHandler(){
            final /* synthetic */ BooleanProperty val$isValidXML;
            {
                this.val$isValidXML = booleanProperty;
            }

            private String createLine(SAXParseException exception) {
                return "line: " + exception.getLineNumber() + ": " + exception.getMessage();
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                ((List)validationProblemsMap.get("warning")).add(this.createLine(exception));
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                ((List)validationProblemsMap.get("error")).add(this.createLine(exception));
                this.val$isValidXML.set(false);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                ((List)validationProblemsMap.get("fatalError")).add(this.createLine(exception));
                this.val$isValidXML.set(false);
            }
        });
        Document xmlDocument = xmlBuilder.parse(new InputSource(new StringReader(xml)));
        Validator validator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema).newValidator();
        try {
            validator.validate(new DOMSource(xmlDocument.getFirstChild()));
        }
        catch (SAXException ex) {
            ((List)validationProblemsMap.get("fatalError (discontinue)")).add(ex.getMessage());
            isValidXML.set(false);
        }
        String validationOutput = validationProblemsMap.entrySet().stream().sorted((entryA, entryB) -> ((String)entryA.getKey()).compareTo((String)entryB.getKey())).flatMap(entry -> ((List)entry.getValue()).stream().map(cause -> (String)entry.getKey() + ": " + cause)).collect(Collectors.joining("\n"));
        if (isValidXML.get()) {
            if (!validationOutput.isEmpty()) {
                LOGGER.log(Level.WARNING, validationOutput);
            }
            validationResult = Optional.empty();
        } else {
            validationResult = Optional.of(validationOutput);
        }
        return validationResult;
    }
}

