/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.element;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.CodeElements;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.lang.Preconditions;
import java.util.Iterator;

public final class ImmutableCodeElement
extends AbstractCodeElement {
    private final ImmutableList<CodeElement> elements;

    private ImmutableCodeElement(ImmutableList<CodeElement> elements) {
        this.elements = elements;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeCodeElements((Iterable<? extends CodeElement>)this.elements);
    }

    public final ImmutableCodeElement append(CodeElement element) {
        return new ImmutableCodeElement(this.append0(element));
    }

    private ImmutableList<CodeElement> append0(CodeElement element) {
        return GrowableList.newList().fluentAddAll(this.elements).fluentAdd((Object)element).toImmutableList();
    }

    public static final class Builder {
        private final GrowableList<CodeElement> els = GrowableList.newList();

        private Builder() {
        }

        public final ImmutableCodeElement build() {
            return new ImmutableCodeElement(this.els.toImmutableList());
        }

        public final Builder with(String string) {
            Preconditions.checkNotNull((Object)string, (String)"string == null");
            return this.withCodeElement(CodeElements.ofRaw(string));
        }

        public final Builder withCloseAngle() {
            return this.withCodeElement(CodeElements.CLOSE_ANGLE);
        }

        public final Builder withCloseBrace() {
            return this.withCodeElement(CodeElements.CLOSE_BRACE);
        }

        public final Builder withCloseBracket() {
            return this.withCodeElement(CodeElements.CLOSE_BRACKET);
        }

        public final Builder withCloseParens() {
            return this.withCodeElement(CodeElements.CLOSE_PARENS);
        }

        public final Builder withCodeElement(CodeElement element) {
            this.els.addWithNullMessage((Object)element, "element == null");
            return this;
        }

        public final Builder withCodeElements(Iterable<? extends CodeElement> elements) {
            this.els.addAll(elements);
            return this;
        }

        public final Builder withColon() {
            return this.withCodeElement(CodeElements.COLON);
        }

        public final Builder withCommaSeparated(CodeElement ... elements) {
            return this.withCommaSeparated((Iterable<? extends CodeElement>)ImmutableList.newListWithAll((Object[])elements));
        }

        public final Builder withCommaSeparated(Iterable<? extends CodeElement> elements) {
            Preconditions.checkNotNull(elements, (String)"elements == null");
            Iterator<? extends CodeElement> it = elements.iterator();
            if (it.hasNext()) {
                this.els.add((Object)it.next());
                while (it.hasNext()) {
                    this.els.add((Object)CodeElements.COMMA);
                    this.els.add((Object)it.next());
                }
            }
            return this;
        }

        public final Builder withDot() {
            return this.withCodeElement(CodeElements.DOT);
        }

        public final Builder withIndentIfNecessary() {
            return this.withCodeElement(CodeElements.INDENT_IF_NECESSARY);
        }

        public final Builder withOpenAngle() {
            return this.withCodeElement(CodeElements.OPEN_ANGLE);
        }

        public final Builder withOpenBrace() {
            return this.withCodeElement(CodeElements.OPEN_BRACE);
        }

        public final Builder withOpenBracket() {
            return this.withCodeElement(CodeElements.OPEN_BRACKET);
        }

        public final Builder withOpenParens() {
            return this.withCodeElement(CodeElements.OPEN_PARENS);
        }

        public final Builder withQuestionMark() {
            return this.withCodeElement(CodeElements.QUESTION_MARK);
        }

        public final Builder withSpaceOff() {
            return this.withCodeElement(CodeElements.SPACE_OFF);
        }

        public final Builder withSpaceOn() {
            return this.withCodeElement(CodeElements.SPACE_ON);
        }

        public final Builder withStringLiteral(String s) {
            Preconditions.checkNotNull((Object)s, (String)"s == null");
            return this.withCodeElement(CodeElements.ofStringLiteral(s));
        }

        public final Builder withTypeName(TypeName typeName) {
            return this.withCodeElement(CodeElements.ofTypeName(typeName));
        }

        public final Builder withWord(char c) {
            return this.withCodeElement(CodeElements.ofWord(c));
        }

        public final Builder withWord(String word) {
            Preconditions.checkNotNull((Object)word, (String)"word == null");
            return this.withCodeElement(CodeElements.ofWord(word));
        }
    }
}

