/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.declaration.ParameterCode;
import br.com.objectos.code.java.expression.AdditiveExpression;
import br.com.objectos.code.java.expression.AdditiveExpressionImpl;
import br.com.objectos.code.java.expression.AdditiveOperator;
import br.com.objectos.code.java.expression.AndExpression;
import br.com.objectos.code.java.expression.AndExpressionImpl;
import br.com.objectos.code.java.expression.Argument;
import br.com.objectos.code.java.expression.ArrayAccess;
import br.com.objectos.code.java.expression.ArrayAccessImpl;
import br.com.objectos.code.java.expression.ArrayCreationExpression;
import br.com.objectos.code.java.expression.ArrayCreationExpressionImpl;
import br.com.objectos.code.java.expression.ArrayInitializer;
import br.com.objectos.code.java.expression.ArrayInitializerImpl;
import br.com.objectos.code.java.expression.ArrayReferenceExpression;
import br.com.objectos.code.java.expression.Assignment;
import br.com.objectos.code.java.expression.AssignmentImpl;
import br.com.objectos.code.java.expression.AssignmentOperator;
import br.com.objectos.code.java.expression.Callee;
import br.com.objectos.code.java.expression.CastExpression;
import br.com.objectos.code.java.expression.CastExpressionImpl;
import br.com.objectos.code.java.expression.ClassInstanceCreationExpression;
import br.com.objectos.code.java.expression.ClassInstanceCreationExpressionImpl;
import br.com.objectos.code.java.expression.ConditionalAndExpression;
import br.com.objectos.code.java.expression.ConditionalAndExpressionImpl;
import br.com.objectos.code.java.expression.ConditionalExpression;
import br.com.objectos.code.java.expression.ConditionalExpressionImpl;
import br.com.objectos.code.java.expression.ConditionalOrExpression;
import br.com.objectos.code.java.expression.ConditionalOrExpressionImpl;
import br.com.objectos.code.java.expression.EqualityExpression;
import br.com.objectos.code.java.expression.EqualityExpressionImpl;
import br.com.objectos.code.java.expression.ExclusiveOrExpression;
import br.com.objectos.code.java.expression.ExclusiveOrExpressionImpl;
import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.ExpressionName;
import br.com.objectos.code.java.expression.ExpressionNameImpl;
import br.com.objectos.code.java.expression.FieldAccess;
import br.com.objectos.code.java.expression.FieldAccessImpl;
import br.com.objectos.code.java.expression.FieldAccessReferenceExpression;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.IdentifierImpl;
import br.com.objectos.code.java.expression.InclusiveOrExpression;
import br.com.objectos.code.java.expression.InclusiveOrExpressionImpl;
import br.com.objectos.code.java.expression.LambdaBody;
import br.com.objectos.code.java.expression.LambdaExpression;
import br.com.objectos.code.java.expression.LambdaExpressionImpl;
import br.com.objectos.code.java.expression.LambdaParameter;
import br.com.objectos.code.java.expression.LeftHandSide;
import br.com.objectos.code.java.expression.Literal;
import br.com.objectos.code.java.expression.LiteralImpl;
import br.com.objectos.code.java.expression.MethodInvocation;
import br.com.objectos.code.java.expression.MethodInvocationImpl;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.MethodReferenceImpl;
import br.com.objectos.code.java.expression.MethodReferenceReferenceExpression;
import br.com.objectos.code.java.expression.MultiplicativeExpression;
import br.com.objectos.code.java.expression.MultiplicativeExpressionImpl;
import br.com.objectos.code.java.expression.MultiplicativeOperator;
import br.com.objectos.code.java.expression.ParenthesizedExpression;
import br.com.objectos.code.java.expression.ParenthesizedExpressionImpl;
import br.com.objectos.code.java.expression.PostDecrementExpression;
import br.com.objectos.code.java.expression.PostDecrementExpressionImpl;
import br.com.objectos.code.java.expression.PostIncrementExpression;
import br.com.objectos.code.java.expression.PostIncrementExpressionImpl;
import br.com.objectos.code.java.expression.PostfixExpression;
import br.com.objectos.code.java.expression.PreDecrementExpression;
import br.com.objectos.code.java.expression.PreDecrementExpressionImpl;
import br.com.objectos.code.java.expression.PreIncrementExpression;
import br.com.objectos.code.java.expression.PreIncrementExpressionImpl;
import br.com.objectos.code.java.expression.RelationalExpression;
import br.com.objectos.code.java.expression.RelationalExpressionImpl;
import br.com.objectos.code.java.expression.RelationalOperator;
import br.com.objectos.code.java.expression.ShiftExpression;
import br.com.objectos.code.java.expression.ShiftExpressionImpl;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpression;
import br.com.objectos.code.java.expression.UnaryExpressionImpl;
import br.com.objectos.code.java.expression.UnaryExpressionNotPlusMinus;
import br.com.objectos.code.java.expression.UnaryOperator;
import br.com.objectos.code.java.statement.VariableInitializer;
import br.com.objectos.code.java.type.ArrayTypeName;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.PrimitiveTypeName;
import br.com.objectos.code.java.type.ReferenceTypeName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.lang.Preconditions;

public class Expressions {
    private Expressions() {
    }

    public static AdditiveExpression add(AdditiveExpression lhs, MultiplicativeExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return AdditiveExpressionImpl.of0(AdditiveOperator.ADDITION, lhs, rhs);
    }

    public static AdditiveExpression subtract(AdditiveExpression lhs, MultiplicativeExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return AdditiveExpressionImpl.of0(AdditiveOperator.SUBTRACTION, lhs, rhs);
    }

    public static AndExpression bitwiseAnd(AndExpression lhs, EqualityExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return AndExpressionImpl.bitwiseAnd0(lhs, rhs);
    }

    public static ArrayAccess aget(ArrayReferenceExpression ref, ExpressionCode e0) {
        return Expressions.arrayAccess(ref, e0);
    }

    public static ArrayAccess aget(ArrayReferenceExpression ref, ExpressionCode e0, ExpressionCode e1) {
        return Expressions.arrayAccess(ref, e0, e1);
    }

    public static ArrayAccess aget(ArrayReferenceExpression ref, ExpressionCode e0, ExpressionCode e1, ExpressionCode e2) {
        return Expressions.arrayAccess(ref, e0, e1, e2);
    }

    public static ArrayAccess aget(ArrayReferenceExpression ref, ExpressionCode e0, ExpressionCode e1, ExpressionCode e2, ExpressionCode e3) {
        return Expressions.arrayAccess(ref, e0, e1, e2, e3);
    }

    public static ArrayAccess aget(ArrayReferenceExpression ref, Iterable<? extends ExpressionCode> expressions) {
        return Expressions.arrayAccess(ref, expressions);
    }

    public static ArrayAccess arrayAccess(ArrayReferenceExpression ref, ExpressionCode e0) {
        Preconditions.checkNotNull((Object)ref, (String)"ref == null");
        Preconditions.checkNotNull((Object)e0, (String)"e0 == null");
        return ArrayAccessImpl.arrayAccess0(ref, e0);
    }

    public static ArrayAccess arrayAccess(ArrayReferenceExpression ref, ExpressionCode e0, ExpressionCode e1) {
        Preconditions.checkNotNull((Object)ref, (String)"ref == null");
        Preconditions.checkNotNull((Object)e0, (String)"e0 == null");
        Preconditions.checkNotNull((Object)e1, (String)"e1 == null");
        return ArrayAccessImpl.arrayAccess0(ref, e0, e1);
    }

    public static ArrayAccess arrayAccess(ArrayReferenceExpression ref, ExpressionCode e0, ExpressionCode e1, ExpressionCode e2) {
        Preconditions.checkNotNull((Object)ref, (String)"ref == null");
        Preconditions.checkNotNull((Object)e0, (String)"e0 == null");
        Preconditions.checkNotNull((Object)e1, (String)"e1 == null");
        Preconditions.checkNotNull((Object)e2, (String)"e2 == null");
        return ArrayAccessImpl.arrayAccess0(ref, e0, e1, e2);
    }

    public static ArrayAccess arrayAccess(ArrayReferenceExpression ref, ExpressionCode e0, ExpressionCode e1, ExpressionCode e2, ExpressionCode e3) {
        Preconditions.checkNotNull((Object)ref, (String)"ref == null");
        Preconditions.checkNotNull((Object)e0, (String)"e0 == null");
        Preconditions.checkNotNull((Object)e1, (String)"e1 == null");
        Preconditions.checkNotNull((Object)e2, (String)"e2 == null");
        Preconditions.checkNotNull((Object)e3, (String)"e3 == null");
        return ArrayAccessImpl.arrayAccess0(ref, e0, e1, e2, e3);
    }

    public static ArrayAccess arrayAccess(ArrayReferenceExpression ref, Iterable<? extends ExpressionCode> expressions) {
        Preconditions.checkNotNull((Object)ref, (String)"ref == null");
        Preconditions.checkNotNull(expressions, (String)"expressions == null");
        return ArrayAccessImpl.arrayAccess0(ref, expressions);
    }

    public static ArrayCreationExpression _new(ArrayTypeName type, ExpressionCode dim0) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        Preconditions.checkNotNull((Object)dim0, (String)"dim0 == null");
        return ArrayCreationExpressionImpl._new0(type, dim0);
    }

    public static ArrayCreationExpression _new(ArrayTypeName type, ExpressionCode dim0, ExpressionCode dim1) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        Preconditions.checkNotNull((Object)dim0, (String)"dim0 == null");
        Preconditions.checkNotNull((Object)dim1, (String)"dim1 == null");
        return ArrayCreationExpressionImpl._new0(type, dim0, dim1);
    }

    public static ArrayCreationExpression _new(ArrayTypeName type, ExpressionCode dim0, ExpressionCode dim1, ExpressionCode dim2) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        Preconditions.checkNotNull((Object)dim0, (String)"dim0 == null");
        Preconditions.checkNotNull((Object)dim1, (String)"dim1 == null");
        Preconditions.checkNotNull((Object)dim2, (String)"dim2 == null");
        return ArrayCreationExpressionImpl._new0(type, dim0, dim1, dim2);
    }

    public static ArrayCreationExpression _new(ArrayTypeName type, ExpressionCode dim0, ExpressionCode dim1, ExpressionCode dim2, ExpressionCode dim3) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        Preconditions.checkNotNull((Object)dim0, (String)"dim0 == null");
        Preconditions.checkNotNull((Object)dim1, (String)"dim1 == null");
        Preconditions.checkNotNull((Object)dim2, (String)"dim2 == null");
        Preconditions.checkNotNull((Object)dim3, (String)"dim3 == null");
        return ArrayCreationExpressionImpl._new0(type, dim0, dim1, dim2, dim3);
    }

    public static ArrayCreationExpression _new(ArrayTypeName type, Iterable<? extends ExpressionCode> dims) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        Preconditions.checkNotNull(dims, (String)"dims == null");
        return ArrayCreationExpressionImpl._new0(type, dims);
    }

    public static ArrayInitializer a() {
        return ArrayInitializerImpl.EMPTY;
    }

    public static ArrayInitializer a(VariableInitializer v0) {
        Preconditions.checkNotNull((Object)v0, (String)"v0 == null");
        return ArrayInitializerImpl.a0(v0);
    }

    public static ArrayInitializer a(VariableInitializer v0, VariableInitializer v1) {
        Preconditions.checkNotNull((Object)v0, (String)"v0 == null");
        Preconditions.checkNotNull((Object)v1, (String)"v1 == null");
        return ArrayInitializerImpl.a0(v0, v1);
    }

    public static ArrayInitializer a(VariableInitializer v0, VariableInitializer v1, VariableInitializer v2) {
        Preconditions.checkNotNull((Object)v0, (String)"v0 == null");
        Preconditions.checkNotNull((Object)v1, (String)"v1 == null");
        Preconditions.checkNotNull((Object)v2, (String)"v2 == null");
        return ArrayInitializerImpl.a0(v0, v1, v2);
    }

    public static ArrayInitializer a(VariableInitializer v0, VariableInitializer v1, VariableInitializer v2, VariableInitializer v3) {
        Preconditions.checkNotNull((Object)v0, (String)"v0 == null");
        Preconditions.checkNotNull((Object)v1, (String)"v1 == null");
        Preconditions.checkNotNull((Object)v2, (String)"v2 == null");
        Preconditions.checkNotNull((Object)v3, (String)"v3 == null");
        return ArrayInitializerImpl.a0(v0, v1, v2, v3);
    }

    public static ArrayInitializer a(VariableInitializer v0, VariableInitializer v1, VariableInitializer v2, VariableInitializer v3, VariableInitializer v4) {
        Preconditions.checkNotNull((Object)v0, (String)"v0 == null");
        Preconditions.checkNotNull((Object)v1, (String)"v1 == null");
        Preconditions.checkNotNull((Object)v2, (String)"v2 == null");
        Preconditions.checkNotNull((Object)v3, (String)"v3 == null");
        Preconditions.checkNotNull((Object)v4, (String)"v4 == null");
        return ArrayInitializerImpl.a0(v0, v1, v2, v3, v4);
    }

    public static ArrayInitializer a(VariableInitializer v0, VariableInitializer v1, VariableInitializer v2, VariableInitializer v3, VariableInitializer v4, VariableInitializer v5) {
        Preconditions.checkNotNull((Object)v0, (String)"v0 == null");
        Preconditions.checkNotNull((Object)v1, (String)"v1 == null");
        Preconditions.checkNotNull((Object)v2, (String)"v2 == null");
        Preconditions.checkNotNull((Object)v3, (String)"v3 == null");
        Preconditions.checkNotNull((Object)v4, (String)"v4 == null");
        Preconditions.checkNotNull((Object)v5, (String)"v5 == null");
        return ArrayInitializerImpl.a0(v0, v1, v2, v3, v4, v5);
    }

    public static ArrayInitializer a(VariableInitializer v0, VariableInitializer v1, VariableInitializer v2, VariableInitializer v3, VariableInitializer v4, VariableInitializer v5, VariableInitializer v6) {
        Preconditions.checkNotNull((Object)v0, (String)"v0 == null");
        Preconditions.checkNotNull((Object)v1, (String)"v1 == null");
        Preconditions.checkNotNull((Object)v2, (String)"v2 == null");
        Preconditions.checkNotNull((Object)v3, (String)"v3 == null");
        Preconditions.checkNotNull((Object)v4, (String)"v4 == null");
        Preconditions.checkNotNull((Object)v5, (String)"v5 == null");
        Preconditions.checkNotNull((Object)v6, (String)"v6 == null");
        return ArrayInitializerImpl.a0(v0, v1, v2, v3, v4, v5, v6);
    }

    public static ArrayInitializer a(VariableInitializer ... elements) {
        Preconditions.checkNotNull((Object)elements, (String)"elements == null");
        switch (elements.length) {
            case 0: {
                return Expressions.a();
            }
            case 1: {
                return Expressions.a(elements[0]);
            }
            case 2: {
                return Expressions.a(elements[0], elements[1]);
            }
            case 3: {
                return Expressions.a(elements[0], elements[1], elements[2]);
            }
            case 4: {
                return Expressions.a(elements[0], elements[1], elements[2], elements[3]);
            }
            case 5: {
                return Expressions.a(elements[0], elements[1], elements[2], elements[3], elements[4]);
            }
            case 6: {
                return Expressions.a(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
            }
            case 7: {
                return Expressions.a(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6]);
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            Preconditions.checkNotNull((Object)elements[i], (String)("v" + i + " == null"));
        }
        return ArrayInitializerImpl.a0(elements);
    }

    public static Assignment assign(LeftHandSide lhs, ExpressionCode rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return AssignmentImpl.assign0(AssignmentOperator.SIMPLE, lhs, rhs);
    }

    public static Assignment assign(AssignmentOperator operator, LeftHandSide lhs, ExpressionCode rhs) {
        Preconditions.checkNotNull((Object)operator, (String)"operator == null");
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return AssignmentImpl.assign0(operator, lhs, rhs);
    }

    public static CastExpression cast(ReferenceTypeName type, UnaryExpressionNotPlusMinus expression) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return CastExpressionImpl.cast0(type, expression);
    }

    public static CastExpression cast(PrimitiveTypeName type, UnaryExpression expression) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return CastExpressionImpl.cast0(type, expression);
    }

    public static ClassInstanceCreationExpression _new(ClassName className) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        return ClassInstanceCreationExpressionImpl.new0(className);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, Argument a1) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, a1);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, Argument a1, Argument a2) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, a1, a2);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, Argument a1, Argument a2, Argument a3) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, a1, a2, a3);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, Argument a1, Argument a2, Argument a3, Argument a4) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        Preconditions.checkNotNull((Object)a4, (String)"a4 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, a1, a2, a3, a4);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, Iterable<? extends Argument> args) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull(args, (String)"args == null");
        return ClassInstanceCreationExpressionImpl.new0(className, args);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, TypeWitness witness) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        return ClassInstanceCreationExpressionImpl.new0(className, witness);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, TypeWitness witness, Argument a1) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, witness, a1);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, TypeWitness witness, Argument a1, Argument a2) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, witness, a1, a2);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, TypeWitness witness, Argument a1, Argument a2, Argument a3) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, witness, a1, a2, a3);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, TypeWitness witness, Argument a1, Argument a2, Argument a3, Argument a4) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        Preconditions.checkNotNull((Object)a4, (String)"a4 == null");
        return ClassInstanceCreationExpressionImpl.new0(className, witness, a1, a2, a3, a4);
    }

    public static ClassInstanceCreationExpression _new(ClassName className, TypeWitness witness, Iterable<? extends Argument> args) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull(args, (String)"args == null");
        return ClassInstanceCreationExpressionImpl.new0(className, witness, args);
    }

    public static ConditionalAndExpression and(ConditionalAndExpression lhs, InclusiveOrExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return ConditionalAndExpressionImpl.and0(lhs, rhs);
    }

    public static ConditionalExpression ternary(ConditionalOrExpression condition, ExpressionCode trueExpression, ConditionalExpression falseExpression) {
        Preconditions.checkNotNull((Object)condition, (String)"condition == null");
        Preconditions.checkNotNull((Object)trueExpression, (String)"trueExpression == null");
        Preconditions.checkNotNull((Object)falseExpression, (String)"falseExpression == null");
        return ConditionalExpressionImpl.ternary0(condition, trueExpression, falseExpression);
    }

    public static ConditionalExpression ternary(ConditionalOrExpression condition, ExpressionCode trueExpression, LambdaExpression falseExpression) {
        Preconditions.checkNotNull((Object)condition, (String)"condition == null");
        Preconditions.checkNotNull((Object)trueExpression, (String)"trueExpression == null");
        Preconditions.checkNotNull((Object)falseExpression, (String)"falseExpression == null");
        return ConditionalExpressionImpl.ternary0(condition, trueExpression, falseExpression);
    }

    public static ConditionalOrExpression or(ConditionalOrExpression lhs, ConditionalAndExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return ConditionalOrExpressionImpl.or0(lhs, rhs);
    }

    public static ExclusiveOrExpression bitwiseXor(ExclusiveOrExpression lhs, AndExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return ExclusiveOrExpressionImpl.bitwiseXor0(lhs, rhs);
    }

    public static EqualityExpression eq(EqualityExpression lhs, RelationalExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return EqualityExpressionImpl.eq0(lhs, rhs);
    }

    public static EqualityExpression ne(EqualityExpression lhs, RelationalExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return EqualityExpressionImpl.ne0(lhs, rhs);
    }

    public static ExpressionName expressionName(Class<?> type, String id) {
        Preconditions.checkNotNull(type, (String)"type == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        return ExpressionNameImpl.expressionName0(ClassName.of(type), Expressions.id(id));
    }

    public static ExpressionName expressionName(ClassName className, Identifier id) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        return ExpressionNameImpl.expressionName0(className, id);
    }

    public static ExpressionName expressionName(ClassName className, String id) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        return ExpressionNameImpl.expressionName0(className, Expressions.id(id));
    }

    public static ExpressionName expressionName(ExpressionName name, String id) {
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        return ExpressionNameImpl.expressionName0(name, Expressions.id(id));
    }

    public static ExpressionName expressionName(ExpressionName name, Identifier id) {
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        return ExpressionNameImpl.expressionName0(name, id);
    }

    public static FieldAccess fieldAccess(FieldAccessReferenceExpression ref, String id) {
        Preconditions.checkNotNull((Object)ref, (String)"ref == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        return FieldAccessImpl.fieldAccess0(ref, Expressions.id(id));
    }

    public static FieldAccess fieldAccess(FieldAccessReferenceExpression ref, Identifier id) {
        Preconditions.checkNotNull((Object)ref, (String)"ref == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        return FieldAccessImpl.fieldAccess0(ref, id);
    }

    public static Identifier id(String name) {
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        return IdentifierImpl.id0(name);
    }

    public static InclusiveOrExpression bitwiseOr(InclusiveOrExpression lhs, ExclusiveOrExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return InclusiveOrExpressionImpl.bitwiseOr0(lhs, rhs);
    }

    public static LambdaExpression lambda(LambdaBody body) {
        Preconditions.checkNotNull((Object)body, (String)"body == null");
        return LambdaExpressionImpl.lambda0(body);
    }

    public static LambdaExpression lambda(Identifier p1, LambdaBody body) {
        Preconditions.checkNotNull((Object)p1, (String)"p1 == null");
        Preconditions.checkNotNull((Object)body, (String)"body == null");
        return LambdaExpressionImpl.lambda0(body, p1);
    }

    public static LambdaExpression lambda(ParameterCode p1, LambdaBody body) {
        Preconditions.checkNotNull((Object)p1, (String)"p1 == null");
        Preconditions.checkNotNull((Object)body, (String)"body == null");
        return LambdaExpressionImpl.lambda0(body, p1);
    }

    public static LambdaExpression lambda(LambdaParameter p1, LambdaParameter p2, LambdaBody body) {
        Preconditions.checkNotNull((Object)p1, (String)"p1 == null");
        Preconditions.checkNotNull((Object)p2, (String)"p2 == null");
        Preconditions.checkNotNull((Object)body, (String)"body == null");
        return LambdaExpressionImpl.lambda0(body, p1, p2);
    }

    public static LambdaExpression lambda(LambdaParameter p1, LambdaParameter p2, LambdaParameter p3, LambdaBody body) {
        Preconditions.checkNotNull((Object)p1, (String)"p1 == null");
        Preconditions.checkNotNull((Object)p2, (String)"p2 == null");
        Preconditions.checkNotNull((Object)p3, (String)"p3 == null");
        Preconditions.checkNotNull((Object)body, (String)"body == null");
        return LambdaExpressionImpl.lambda0(body, p1, p2, p3);
    }

    public static LambdaExpression lambda(LambdaParameter p1, LambdaParameter p2, LambdaParameter p3, LambdaParameter p4, LambdaBody body) {
        Preconditions.checkNotNull((Object)p1, (String)"p1 == null");
        Preconditions.checkNotNull((Object)p2, (String)"p2 == null");
        Preconditions.checkNotNull((Object)p3, (String)"p3 == null");
        Preconditions.checkNotNull((Object)p4, (String)"p4 == null");
        Preconditions.checkNotNull((Object)body, (String)"body == null");
        return LambdaExpressionImpl.lambda0(body, p1, p2, p3, p4);
    }

    public static LambdaExpression lambda(Iterable<? extends LambdaParameter> params, LambdaBody body) {
        Preconditions.checkNotNull(params, (String)"params == null");
        Preconditions.checkNotNull((Object)body, (String)"body == null");
        return LambdaExpressionImpl.lambda0(body, params);
    }

    public static Literal l(boolean value) {
        return LiteralImpl.l0(value);
    }

    public static Literal l(char value) {
        return LiteralImpl.l0(value);
    }

    public static Literal l(double value) {
        return LiteralImpl.l0(value);
    }

    public static Literal l(int value) {
        return LiteralImpl.l0(value);
    }

    public static Literal l(float value) {
        return LiteralImpl.l0(value);
    }

    public static Literal l(long value) {
        return LiteralImpl.l0(value);
    }

    public static Literal l(Class<?> type) {
        Preconditions.checkNotNull(type, (String)"type == null");
        return LiteralImpl.l0(type);
    }

    public static Literal l(ClassName className) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        return LiteralImpl.l0(className);
    }

    public static Literal l(String s) {
        Preconditions.checkNotNull((Object)s, (String)"s == null");
        return LiteralImpl.l0(s);
    }

    public static MethodReference ref(MethodReferenceReferenceExpression expression, String methodName) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        return MethodReferenceImpl.ref0(expression, methodName);
    }

    public static MethodReference ref(MethodReferenceReferenceExpression expression, TypeWitness witness, String methodName) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        return MethodReferenceImpl.ref0(expression, witness, methodName);
    }

    public static MethodReference ref(ReferenceTypeName typeName, String methodName) {
        Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        return MethodReferenceImpl.ref0(typeName, methodName);
    }

    public static MethodReference ref(ReferenceTypeName typeName, TypeWitness witness, String methodName) {
        Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        return MethodReferenceImpl.ref0(typeName, witness, methodName);
    }

    public static MethodInvocation invoke(Callee callee, String methodName) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        return MethodInvocationImpl.invoke0(callee, methodName);
    }

    public static MethodInvocation invoke(Callee callee, String methodName, Argument a1) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        return MethodInvocationImpl.invoke0(callee, methodName, a1);
    }

    public static MethodInvocation invoke(Callee callee, String methodName, Argument a1, Argument a2) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        return MethodInvocationImpl.invoke0(callee, methodName, a1, a2);
    }

    public static MethodInvocation invoke(Callee callee, String methodName, Argument a1, Argument a2, Argument a3) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        return MethodInvocationImpl.invoke0(callee, methodName, a1, a2, a3);
    }

    public static MethodInvocation invoke(Callee callee, String methodName, Argument a1, Argument a2, Argument a3, Argument a4) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        Preconditions.checkNotNull((Object)a4, (String)"a4 == null");
        return MethodInvocationImpl.invoke0(callee, methodName, a1, a2, a3, a4);
    }

    public static MethodInvocation invoke(Callee callee, String methodName, Iterable<? extends Argument> args) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull(args, (String)"args == null");
        return MethodInvocationImpl.invoke0(callee, methodName, args);
    }

    public static MethodInvocation invoke(Callee callee, TypeWitness witness, String methodName) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        return MethodInvocationImpl.invoke0(callee, witness, methodName);
    }

    public static MethodInvocation invoke(Callee callee, TypeWitness witness, String methodName, Argument a1) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        return MethodInvocationImpl.invoke0(callee, witness, methodName, a1);
    }

    public static MethodInvocation invoke(Callee callee, TypeWitness witness, String methodName, Argument a1, Argument a2) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        return MethodInvocationImpl.invoke0(callee, witness, methodName, a1, a2);
    }

    public static MethodInvocation invoke(Callee callee, TypeWitness witness, String methodName, Argument a1, Argument a2, Argument a3) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        return MethodInvocationImpl.invoke0(callee, witness, methodName, a1, a2, a3);
    }

    public static MethodInvocation invoke(Callee callee, TypeWitness witness, String methodName, Argument a1, Argument a2, Argument a3, Argument a4) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        Preconditions.checkNotNull((Object)a4, (String)"a4 == null");
        return MethodInvocationImpl.invoke0(callee, witness, methodName, a1, a2, a3, a4);
    }

    public static MethodInvocation invoke(Callee callee, TypeWitness witness, String methodName, Iterable<? extends Argument> args) {
        Preconditions.checkNotNull((Object)callee, (String)"callee == null");
        Preconditions.checkNotNull((Object)witness, (String)"witness == null");
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull(args, (String)"args == null");
        return MethodInvocationImpl.invoke0(callee, witness, methodName, args);
    }

    public static MethodInvocation invoke(String methodName) {
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        return MethodInvocationImpl.invoke0(methodName);
    }

    public static MethodInvocation invoke(String methodName, Argument a1) {
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        return MethodInvocationImpl.invoke0(methodName, a1);
    }

    public static MethodInvocation invoke(String methodName, Argument a1, Argument a2) {
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        return MethodInvocationImpl.invoke0(methodName, a1, a2);
    }

    public static MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3) {
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        return MethodInvocationImpl.invoke0(methodName, a1, a2, a3);
    }

    public static MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3, Argument a4) {
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull((Object)a1, (String)"a1 == null");
        Preconditions.checkNotNull((Object)a2, (String)"a2 == null");
        Preconditions.checkNotNull((Object)a3, (String)"a3 == null");
        Preconditions.checkNotNull((Object)a4, (String)"a4 == null");
        return MethodInvocationImpl.invoke0(methodName, a1, a2, a3, a4);
    }

    public static MethodInvocation invoke(String methodName, Iterable<? extends Argument> args) {
        Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
        Preconditions.checkNotNull(args, (String)"args == null");
        return MethodInvocationImpl.invoke0(methodName, args);
    }

    public static MultiplicativeExpression divide(MultiplicativeExpression lhs, UnaryExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return MultiplicativeExpressionImpl.of0(MultiplicativeOperator.DIVISION, lhs, rhs);
    }

    public static MultiplicativeExpression multiply(MultiplicativeExpression lhs, UnaryExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return MultiplicativeExpressionImpl.of0(MultiplicativeOperator.MULTIPLICATION, lhs, rhs);
    }

    public static MultiplicativeExpression remainder(MultiplicativeExpression lhs, UnaryExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return MultiplicativeExpressionImpl.of0(MultiplicativeOperator.REMAINDER, lhs, rhs);
    }

    public static ParenthesizedExpression parens(ExpressionCode expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return ParenthesizedExpressionImpl.parens0(expression);
    }

    public static PostDecrementExpression postDec(PostfixExpression expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return PostDecrementExpressionImpl.postDec0(expression);
    }

    public static PostIncrementExpression postInc(PostfixExpression expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return PostIncrementExpressionImpl.postInc0(expression);
    }

    public static PreDecrementExpression preDec(UnaryExpression expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return PreDecrementExpressionImpl.preDec0(expression);
    }

    public static PreIncrementExpression preInc(UnaryExpression expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return PreIncrementExpressionImpl.preInc0(expression);
    }

    public static RelationalExpression lt(RelationalExpression lhs, ShiftExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return RelationalExpressionImpl.of0(RelationalOperator.LT, lhs, rhs);
    }

    public static RelationalExpression gt(RelationalExpression lhs, ShiftExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return RelationalExpressionImpl.of0(RelationalOperator.GT, lhs, rhs);
    }

    public static RelationalExpression le(RelationalExpression lhs, ShiftExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return RelationalExpressionImpl.of0(RelationalOperator.LE, lhs, rhs);
    }

    public static RelationalExpression ge(RelationalExpression lhs, ShiftExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return RelationalExpressionImpl.of0(RelationalOperator.GE, lhs, rhs);
    }

    public static RelationalExpression instanceOf(RelationalExpression subject, ReferenceTypeName test) {
        Preconditions.checkNotNull((Object)subject, (String)"subject == null");
        Preconditions.checkNotNull((Object)test, (String)"test == null");
        return RelationalExpressionImpl.instanceOf0(subject, test);
    }

    public static ShiftExpression leftShift(ShiftExpression lhs, AdditiveExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return ShiftExpressionImpl.leftShift0(lhs, rhs);
    }

    public static ShiftExpression rightShift(ShiftExpression lhs, AdditiveExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return ShiftExpressionImpl.rightShift0(lhs, rhs);
    }

    public static ShiftExpression unsignedRightShift(ShiftExpression lhs, AdditiveExpression rhs) {
        Preconditions.checkNotNull((Object)lhs, (String)"lhs == null");
        Preconditions.checkNotNull((Object)rhs, (String)"rhs == null");
        return ShiftExpressionImpl.unsignedRightShift0(lhs, rhs);
    }

    public static TypeWitness hint() {
        return Expressions.witness();
    }

    public static TypeWitness hint(TypeName t1) {
        return Expressions.witness(t1);
    }

    public static TypeWitness hint(TypeName t1, TypeName t2) {
        return Expressions.witness(t1, t2);
    }

    public static TypeWitness hint(TypeName t1, TypeName t2, TypeName t3) {
        return Expressions.witness(t1, t2, t3);
    }

    public static TypeWitness hint(Iterable<? extends TypeName> types) {
        return Expressions.witness(types);
    }

    public static TypeWitness witness() {
        return TypeWitness.witness0();
    }

    public static TypeWitness witness(TypeName t1) {
        Preconditions.checkNotNull((Object)t1, (String)"t1 == null");
        return TypeWitness.witness0(t1);
    }

    public static TypeWitness witness(TypeName t1, TypeName t2) {
        Preconditions.checkNotNull((Object)t1, (String)"t1 == null");
        Preconditions.checkNotNull((Object)t2, (String)"t2 == null");
        return TypeWitness.witness0(t1, t2);
    }

    public static TypeWitness witness(TypeName t1, TypeName t2, TypeName t3) {
        Preconditions.checkNotNull((Object)t1, (String)"t1 == null");
        Preconditions.checkNotNull((Object)t2, (String)"t2 == null");
        Preconditions.checkNotNull((Object)t3, (String)"t3 == null");
        return TypeWitness.witness0(t1, t2, t3);
    }

    public static TypeWitness witness(Iterable<? extends TypeName> types) {
        Preconditions.checkNotNull(types, (String)"types == null");
        return TypeWitness.witness0(types);
    }

    public static UnaryExpressionNotPlusMinus not(UnaryExpression expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return UnaryExpressionImpl.of0(UnaryOperator.NOT, expression);
    }

    public static UnaryExpression unaryMinus(UnaryExpression expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return UnaryExpressionImpl.of0(UnaryOperator.MINUS, expression);
    }

    public static UnaryExpression unaryPlus(UnaryExpression expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return UnaryExpressionImpl.of0(UnaryOperator.PLUS, expression);
    }
}

