/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.declaration.PackageName;
import br.com.objectos.code.java.expression.Argument;
import br.com.objectos.code.java.expression.Callee;
import br.com.objectos.code.java.expression.CastExpression;
import br.com.objectos.code.java.expression.ExpressionName;
import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.MethodInvocation;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpressionNotPlusMinus;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.JavaFileImportSet;
import br.com.objectos.code.java.type.ClassNameOrParameterizedTypeName;
import br.com.objectos.code.java.type.EnclosingElement;
import br.com.objectos.code.java.type.ParameterizedTypeName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.code.java.type.TypeNameVisitor;
import br.com.objectos.comuns.lang.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class ClassName
implements ClassNameOrParameterizedTypeName,
Comparable<ClassName>,
Callee,
EnclosingElement {
    private static final ClassName OBJECT = PackageName.named("java.lang").nestedClass("Object");
    private final EnclosingElement enclosingElement;
    private final String simpleName;
    private final String toString;

    ClassName(EnclosingElement enclosingElement, String simpleName) {
        this.enclosingElement = enclosingElement;
        this.simpleName = simpleName;
        this.toString = enclosingElement.toString(simpleName);
    }

    public static ClassName object() {
        return OBJECT;
    }

    public static ClassName of(Class<?> type) {
        Preconditions.checkNotNull(type, (String)"type == null");
        return ClassName.ofUnchecked(type);
    }

    public static ClassName of(TypeElement element) {
        Preconditions.checkNotNull((Object)element, (String)"element == null");
        return ClassName.ofUnchecked(element);
    }

    public static ClassName ofUnchecked(Class<?> type) {
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(type.getSimpleName());
        for (Class<?> enclosing = type.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
            nameList.add(enclosing.getSimpleName().toString());
        }
        ClassName result = null;
        EnclosingElement currentName = PackageName.named(type.getPackage().getName());
        Collections.reverse(nameList);
        for (String name : nameList) {
            result = currentName.nestedClass(name);
            currentName = result;
        }
        return result;
    }

    public static ClassName ofUnchecked(TypeElement element) {
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(element.getSimpleName().toString());
        Element enclosing = element.getEnclosingElement();
        while (!enclosing.getKind().equals((Object)ElementKind.PACKAGE)) {
            nameList.add(enclosing.getSimpleName().toString());
            enclosing = enclosing.getEnclosingElement();
        }
        ClassName result = null;
        EnclosingElement currentName = PackageName.of((PackageElement)enclosing);
        Collections.reverse(nameList);
        for (String name : nameList) {
            result = currentName.nestedClass(name);
            currentName = result;
        }
        return result;
    }

    @Override
    public final String acceptJavaFileImportSet(JavaFileImportSet set) {
        if (set.contains(this)) {
            return this.simpleName;
        }
        if (set.canSkipImport(this.packageName())) {
            set.addSimpleName(this.simpleName);
            return this.simpleName;
        }
        if (set.addSimpleName(this.simpleName)) {
            set.addQualifiedName(this);
            return this.simpleName;
        }
        return this.toString();
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeTypeNameAsWord(this);
    }

    @Override
    public final <R, P> R acceptTypeNameVisitor(TypeNameVisitor<R, P> visitor, P p) {
        return visitor.visitClassName(this, p);
    }

    @Override
    public final TypeName arrayCreationTypeName() {
        return this;
    }

    @Override
    public final CastExpression cast(UnaryExpressionNotPlusMinus expression) {
        return Expressions.cast(this, expression);
    }

    @Override
    public final int compareTo(ClassName o) {
        return this.toString.compareTo(o.toString);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof ClassName)) {
            return false;
        }
        ClassName that = (ClassName)obj;
        return this.enclosingElement.equals(that.enclosingElement) && this.simpleName.equals(that.simpleName);
    }

    public final int hashCode() {
        return Objects.hash(this.enclosingElement, this.simpleName);
    }

    public final ExpressionName id(Identifier id) {
        return Expressions.expressionName(this, id);
    }

    public final ExpressionName id(String id) {
        return Expressions.expressionName(this, id);
    }

    @Override
    public final MethodInvocation invoke(String methodName) {
        return Expressions.invoke(this, methodName);
    }

    @Override
    public final MethodInvocation invoke(String methodName, Argument a1) {
        return Expressions.invoke((Callee)this, methodName, a1);
    }

    @Override
    public final MethodInvocation invoke(String methodName, Argument a1, Argument a2) {
        return Expressions.invoke((Callee)this, methodName, a1, a2);
    }

    @Override
    public final MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3) {
        return Expressions.invoke((Callee)this, methodName, a1, a2, a3);
    }

    @Override
    public final MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3, Argument a4) {
        return Expressions.invoke((Callee)this, methodName, a1, a2, a3, a4);
    }

    @Override
    public final MethodInvocation invoke(String methodName, Iterable<? extends Argument> args) {
        return Expressions.invoke((Callee)this, methodName, args);
    }

    @Override
    public final MethodInvocation invoke(TypeWitness witness, String methodName) {
        return Expressions.invoke((Callee)this, witness, methodName);
    }

    @Override
    public final MethodInvocation invoke(TypeWitness witness, String methodName, Argument a1) {
        return Expressions.invoke((Callee)this, witness, methodName, a1);
    }

    @Override
    public final MethodInvocation invoke(TypeWitness witness, String methodName, Argument a1, Argument a2) {
        return Expressions.invoke((Callee)this, witness, methodName, a1, a2);
    }

    @Override
    public final MethodInvocation invoke(TypeWitness witness, String methodName, Argument a1, Argument a2, Argument a3) {
        return Expressions.invoke((Callee)this, witness, methodName, a1, a2, a3);
    }

    @Override
    public final MethodInvocation invoke(TypeWitness witness, String methodName, Argument a1, Argument a2, Argument a3, Argument a4) {
        return Expressions.invoke(this, witness, methodName, a1, a2, a3, a4);
    }

    @Override
    public final MethodInvocation invoke(TypeWitness witness, String methodName, Iterable<? extends Argument> args) {
        return Expressions.invoke((Callee)this, witness, methodName, args);
    }

    @Override
    public final boolean isJavaLangObject() {
        return this.toString.equals("java.lang.Object");
    }

    @Override
    public final PackageName packageName() {
        return this.enclosingElement.packageName();
    }

    @Override
    public final MethodReference ref(String methodName) {
        return Expressions.ref(this, methodName);
    }

    @Override
    public final MethodReference ref(TypeWitness witness, String methodName) {
        return Expressions.ref(this, witness, methodName);
    }

    public final String simpleName() {
        return this.simpleName;
    }

    @Override
    public final Optional<ClassName> toClassName() {
        return Optional.of(this);
    }

    @Override
    public final ClassName toClassNameUnchecked() {
        return this;
    }

    public final String toString() {
        return this.toString;
    }

    public final ClassName withPrefix(String prefix) {
        Preconditions.checkNotNull((Object)prefix, (String)"prefix == null");
        String withPrefix = prefix + this.simpleName;
        this.checkTypeName(withPrefix);
        return new ClassName(this.enclosingElement, withPrefix);
    }

    public final ClassName withSuffix(String suffix) {
        Preconditions.checkNotNull((Object)suffix, (String)"suffix == null");
        String withSuffix = this.simpleName + suffix;
        this.checkTypeName(withSuffix);
        return new ClassName(this.enclosingElement, withSuffix);
    }

    @Override
    public final ParameterizedTypeName withTypeArgument(TypeName type) {
        return ParameterizedTypeName.of(this, type);
    }

    private void checkTypeName(String simpleName) {
        Preconditions.checkArgument((simpleName != null && SourceVersion.isName(simpleName) ? 1 : 0) != 0, (String)"%s is not a valid type name", (Object[])new Object[]{simpleName});
    }
}

