/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.expression.LambdaParameter;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.lang.Preconditions;
import java.util.Objects;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class ParameterCode
extends AbstractCodeElement
implements LambdaParameter {
    private final TypeName typeName;
    private final String name;

    ParameterCode(TypeName typeName, String name) {
        this.typeName = typeName;
        this.name = name;
    }

    public static ParameterCode of(VariableElement element) {
        Preconditions.checkNotNull((Object)element, (String)"element == null");
        TypeMirror type = element.asType();
        return new ParameterCode(TypeName.ofUnchecked(type), element.getSimpleName().toString());
    }

    public static ParameterCode of(Class<?> type, String name) {
        ClassName typeName = ClassName.of(type);
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        return new ParameterCode(typeName, name);
    }

    public static ParameterCode of(TypeName typeName, String name) {
        Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        return new ParameterCode(typeName, name);
    }

    static ParameterCode ofUnchecked(TypeName typeName, String name) {
        return new ParameterCode(typeName, name);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter writer) {
        return writer.writeTypeNameAsWord(this.typeName).writeWord(this.name);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParameterCode)) {
            return false;
        }
        ParameterCode that = (ParameterCode)obj;
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.name, that.name);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.typeName, this.name);
    }

    public final String name() {
        return this.name;
    }

    public final TypeName typeName() {
        return this.typeName;
    }
}

