/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.element;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CharCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.TypeName;

final class CodeElements {
    static final CodeElement CLOSE_ANGLE = new CharCodeElement('>');
    static final CodeElement CLOSE_BRACE = new CharCodeElement('}');
    static final CodeElement CLOSE_BRACKET = new CharCodeElement(']');
    static final CodeElement CLOSE_PARENS = new CharCodeElement(')');
    static final CodeElement COLON = new CharCodeElement(':');
    static final CodeElement COMMA = new AbstractCodeElement(){

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.spaceOff().writeWord(',');
        }
    };
    static final CodeElement DOT = new CharCodeElement('.');
    static final CodeElement INDENT_IF_NECESSARY = new AbstractCodeElement(){

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.writePreIndentation();
        }
    };
    static final CodeElement OPEN_ANGLE = new CharCodeElement('<');
    static final CodeElement OPEN_BRACE = new CharCodeElement('{');
    static final CodeElement OPEN_BRACKET = new CharCodeElement('[');
    static final CodeElement OPEN_PARENS = new CharCodeElement('(');
    static final CodeElement QUESTION_MARK = new CharCodeElement('?');
    static final CodeElement SPACE_OFF = new AbstractCodeElement(){

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.spaceOff();
        }
    };
    static final CodeElement SPACE_ON = new AbstractCodeElement(){

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.spaceOn();
        }
    };

    private CodeElements() {
    }

    static CodeElement ofRaw(String string) {
        return new RawString(string);
    }

    static CodeElement ofStringLiteral(String s) {
        return new StringLiteral(s);
    }

    static CodeElement ofTypeName(TypeName typeName) {
        return new TypeNameCodeElement(typeName);
    }

    static CodeElement ofWord(char c) {
        return new CharWordCodeElement(c);
    }

    static CodeElement ofWord(String word) {
        return new SingleWordCodeElement(word);
    }

    private static class SingleWordCodeElement
    extends AbstractCodeElement {
        private final String value;

        SingleWordCodeElement(String value) {
            this.value = value;
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.writeWord(this.value);
        }
    }

    private static class TypeNameCodeElement
    extends AbstractCodeElement {
        private final TypeName typeName;

        TypeNameCodeElement(TypeName typeName) {
            this.typeName = typeName;
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.writeTypeNameAsWord(this.typeName);
        }
    }

    private static class StringLiteral
    extends AbstractCodeElement {
        private final String value;

        StringLiteral(String value) {
            this.value = value;
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.writeStringLiteral(this.value);
        }
    }

    private static class RawString
    extends AbstractCodeElement {
        private final String value;

        RawString(String value) {
            this.value = value;
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.write(this.value);
        }
    }

    private static class CharWordCodeElement
    extends AbstractCodeElement {
        private final char value;

        CharWordCodeElement(char value) {
            this.value = value;
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.writeWord(this.value);
        }
    }
}

