/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.Section;

abstract class Indentation
implements CodeElement {
    Indentation() {
    }

    public static Indentation start() {
        return new Start();
    }

    public abstract Indentation nextLine();

    public abstract Indentation pop();

    public final Indentation push(Section section) {
        return new Rest(this, section);
    }

    abstract int indentation();

    private static class Rest
    extends Indentation {
        private final Indentation parent;
        private final Section section;
        private boolean nextLine;

        Rest(Indentation parent, Section section) {
            this.parent = parent;
            this.section = section;
        }

        @Override
        public CodeWriter acceptCodeWriter(CodeWriter w) {
            return this.nextLine ? w.writeIndentation(this.indentation()) : this.parent.acceptCodeWriter(w);
        }

        @Override
        public final Indentation nextLine() {
            this.nextLine = true;
            return this;
        }

        @Override
        public final Indentation pop() {
            return this.parent;
        }

        @Override
        final int indentation() {
            return this.parent.indentation() + (this.nextLine ? this.section.indentationOnNextLine : this.section.indentation);
        }
    }

    private static class Start
    extends Indentation {
        private Start() {
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w;
        }

        @Override
        public final Indentation nextLine() {
            return this;
        }

        @Override
        public final Indentation pop() {
            throw new IllegalStateException("Cannot pop an empty SectionStack.");
        }

        @Override
        final int indentation() {
            return 0;
        }
    }
}

