/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockElement;

abstract class AbstractControlStatement
extends AbstractStatement {
    private final ExpressionCode expression;
    private final Block block;

    AbstractControlStatement(ExpressionCode expression, Block block) {
        this.expression = expression;
        this.block = block;
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeControl(this.keyword(), this.expression).writeCodeElement(this.block);
    }

    abstract String keyword();

    static abstract class AbstractBuilder<T extends AbstractControlStatement> {
        private final ExpressionCode expression;

        AbstractBuilder(ExpressionCode expression) {
            this.expression = expression;
        }

        public final T block(BlockElement ... elements) {
            Block block = Block.of(elements);
            return this.bodyImpl(this.expression, block);
        }

        abstract T bodyImpl(ExpressionCode var1, Block var2);
    }
}

