/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.BlockStatement;
import br.com.objectos.code.java.statement.TryCatchFinallyStatement;
import br.com.objectos.code.java.statement.TryElement;
import br.com.objectos.code.java.statement.TryStatement;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterator;

public class TryCatchStatement
extends AbstractStatement
implements TryStatement {
    private final TryElement tryElement;
    private final ImmutableList<TypeName> exceptionTypes;
    private final Identifier id;
    private final Block block;

    private TryCatchStatement(TryElement tryElement, ImmutableList<TypeName> exceptionTypes, Identifier id, Block block) {
        this.tryElement = tryElement;
        this.exceptionTypes = exceptionTypes;
        this.id = id;
        this.block = block;
    }

    static Builder builder(TryElement tryElement, ImmutableList<TypeName> exceptionTypes, Identifier id) {
        return new Builder(tryElement, exceptionTypes, id);
    }

    public final TryCatchFinallyStatement _finally(BlockStatement ... statements) {
        Block block = Block.of(statements);
        return new TryCatchFinallyStatement(this, block);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        w.writeCodeElement(this.tryElement).spaceOn();
        w.writeWord("catch").writeWord('(').spaceOff();
        StreamIterator exIter = this.exceptionTypes.iterator();
        if (exIter.hasNext()) {
            w.writeTypeNameAsWord((TypeName)exIter.next());
            while (exIter.hasNext()) {
                w.writeWord('|');
                w.writeTypeNameAsWord((TypeName)exIter.next());
            }
        }
        w.writeCodeElement(this.id).spaceOff().writeWord(')');
        w.writeCodeElement(this.block);
        return w;
    }

    public static class Builder {
        private final TryElement tryElement;
        private final ImmutableList<TypeName> exceptionTypes;
        private final Identifier id;

        private Builder(TryElement tryElement, ImmutableList<TypeName> exceptionTypes, Identifier id) {
            this.tryElement = tryElement;
            this.exceptionTypes = exceptionTypes;
            this.id = id;
        }

        public final TryCatchStatement block(BlockElement ... elements) {
            Block block = Block.of(elements);
            return new TryCatchStatement(this.tryElement, this.exceptionTypes, this.id, block);
        }
    }
}

