/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.CodeJava;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.NewLine;
import br.com.objectos.code.java.expression.Argument;
import br.com.objectos.code.java.expression.Arguments;
import br.com.objectos.code.java.expression.ChainedMethodInvocation;
import br.com.objectos.code.java.expression.Expression;
import br.com.objectos.code.java.expression.InclusiveOrExpression;
import br.com.objectos.code.java.expression.LambdaBody;
import br.com.objectos.code.java.expression.MethodInvocationImpl;
import br.com.objectos.code.java.expression.Operator;
import br.com.objectos.code.java.statement.VariableInitializer;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.lang.Preconditions;

public interface ExpressionCode
extends CodeElement,
LambdaBody,
VariableInitializer {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ExpressionCode startingExpression) {
        return ExpressionCode.builder().withExpression(startingExpression);
    }

    public static class Builder {
        private final GrowableList<CodeElement> elements = GrowableList.newList();
        private boolean chain;

        private Builder() {
        }

        public final Expression build() {
            return new Expression((ImmutableList<CodeElement>)this.elements.toImmutableList());
        }

        public final Builder and(InclusiveOrExpression rhs) {
            return this.add(Operator.AND).add(rhs).setChain();
        }

        public final Builder id(String name) {
            return this.add(CodeJava.id(name)).setChain();
        }

        public final Builder invoke(String methodName, Argument ... args) {
            Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
            Preconditions.checkNotNull((Object)args, (String)"args == null");
            return this.invoke0(methodName, Arguments.of(args));
        }

        public final Builder invoke(String methodName, Iterable<? extends Argument> args) {
            Preconditions.checkNotNull((Object)methodName, (String)"methodName == null");
            Preconditions.checkNotNull(args, (String)"args == null");
            return this.invoke0(methodName, Arguments.of(args));
        }

        public final Builder nl() {
            return this.add(NewLine.nextLine());
        }

        final Builder withExpression(ExpressionCode expression) {
            return this.add(expression).setChain();
        }

        private Builder add(CodeElement element) {
            this.elements.add((Object)element);
            return this;
        }

        private Builder invoke0(String methodName, Arguments args) {
            ExpressionCode invocation = this.chain ? ChainedMethodInvocation.ofUnchecked(methodName, args) : MethodInvocationImpl.invoke1(methodName, args);
            return this.add(invocation).setChain();
        }

        private Builder setChain() {
            this.chain = true;
            return this;
        }
    }
}

