/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.element;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.type.ClassName;

public class Keywords {

  private static final SuperKeyword SUPER = KeywordImpl.named("super");

  private Keywords() {}

  public static SuperKeyword _super() {
    return SUPER;
  }

  public static QualifiedSuperKeyword _super(Class<?> type) {
    checkNotNull(type, "type == null");
    return QualifiedSuperKeyword.ofUnchecked(ClassName.of(type));
  }

  public static QualifiedSuperKeyword _super(ClassName className) {
    checkNotNull(className, "className == null");
    return QualifiedSuperKeyword.ofUnchecked(className);
  }

}
