/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;

final class AndExpressionImpl
    extends AbstractDefaultCodeElement
    implements AndExpression {

  private AndExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static AndExpression bitwiseAnd0(AndExpression lhs, EqualityExpression rhs) {
    return new AndExpressionImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(lhs)
            .withWord('&')
            .withCodeElement(rhs)
            .build()
    );
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    throw newUoe(AndExpression.class);
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(AndExpression.class);
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final Callee selfCallee() {
    throw newUoe(AndExpression.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    throw newUoe(AndExpression.class);
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    throw newUoe(AndExpression.class);
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    throw newUoe(AndExpression.class);
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    throw newUoe(AndExpression.class);
  }

}
