/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.comuns.collections.ImmutableList;

final class Arguments extends AbstractForwardingCodeElement {

  private static final Arguments EMPTY = new Arguments(
      ImmutableCodeElement.builder()
          .withOpenParens()
          .withSpaceOff()
          .withCloseParens()
          .build()
  );

  private Arguments(ImmutableCodeElement delegate) {
    super(delegate);
  }

  public static Arguments empty() {
    return EMPTY;
  }

  public static Arguments of(CodeElement... args) {
    ImmutableList<CodeElement> arguments = ImmutableList.newListWithAll(args);
    return of(arguments);
  }

  public static Arguments of(Iterable<? extends CodeElement> args) {
    return new Arguments(
        ImmutableCodeElement.builder()
            .withOpenParens()
            .withSpaceOff()
            .withCommaSeparated(args)
            .withSpaceOff()
            .withCloseParens()
            .build()
    );
  }

}