/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;

final class ChainedMethodInvocation extends AbstractCodeElement implements ExpressionCode {

  private final String methodName;
  private final Arguments arguments;

  private ChainedMethodInvocation(String methodName, Arguments arguments) {
    this.methodName = methodName;
    this.arguments = arguments;
  }

  static ChainedMethodInvocation ofUnchecked(String methodName, Argument... args) {
    return ofUnchecked(methodName, Arguments.of(args));
  }

  static ChainedMethodInvocation ofUnchecked(String methodName, Arguments args) {
    return new ChainedMethodInvocation(methodName, args);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w
        .writePreIndentation()
        .write('.')
        .write(methodName)
        .spaceOff()
        .writeCodeElement(arguments);
  }

}