/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.type.ReferenceTypeName;

final class RelationalExpressionImpl
    extends AbstractDefaultCodeElement
    implements RelationalExpression {

  private RelationalExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static RelationalExpression of0(
      RelationalOperator operator, RelationalExpression lhs, ShiftExpression rhs) {
    return new RelationalExpressionImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(lhs)
            .withCodeElement(operator)
            .withCodeElement(rhs)
            .build()
    );
  }

  static RelationalExpression instanceOf0(
      RelationalExpression subject, ReferenceTypeName test) {
    return build0(
        ImmutableCodeElement.builder()
            .withCodeElement(subject)
            .withWord("instanceof")
            .withTypeName(test)
            .build()
    );
  }

  private static RelationalExpression build0(ImmutableCodeElement delegate) {
    return new RelationalExpressionImpl(delegate);
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    throw newUoe(RelationalExpression.class);
  }

  @Override
  protected final Callee selfCallee() {
    throw newUoe(RelationalExpression.class);
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(RelationalExpression.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    throw newUoe(RelationalExpression.class);
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    throw newUoe(RelationalExpression.class);
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    throw newUoe(RelationalExpression.class);
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}