/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterable;

abstract class FormattingAction {

  private final GrowableList<BodyElement> elements = GrowableList.newList();
  private final FormattingAction nextAction;

  FormattingAction(FormattingAction nextAction) {
    this.nextAction = nextAction;
  }

  public abstract void consume(FormattingSource source);

  public abstract void consumeElement(BodyElement element);

  public StreamIterable<BodyElement> stream() {
    return elementsStream().concat(nextAction.stream());
  }

  public final <E extends BodyElement> ImmutableList<E> toImmutableList(Class<E> type) {
    return stream().map(type::cast).toImmutableList();
  }

  StreamIterable<BodyElement> elementsStream() {
    return elements;
  }

  final void nextAction(FormattingSource source) {
    nextAction.consume(source);
  }

  final void storeElement(BodyElement element) {
    elements.add(element);
  }

  public final void propagateElement(BodyElement element) {
    nextAction.consumeElement(element);
  }

}