/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.collections.ImmutableList.newListWithAll;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.comuns.collections.ImmutableList;

final class SimpleStatementCode extends AbstractStatement {

  private final ImmutableList<CodeElement> elements;

  SimpleStatementCode(ImmutableList<CodeElement> elements) {
    this.elements = elements;
  }

  static Statement fromExpressionUnchecked(ExpressionCode expression) {
    return newWithAll(expression);
  }

  static Statement newWithAll(CodeElement... elements) {
    return new SimpleStatementCode(newListWithAll(elements));
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    for (CodeElement element : elements) {
      w = w.writeCodeElement(element);
    }
    return w;
  }

}