/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;

final class ConditionalExpressionImpl
    extends AbstractForwardingCodeElement
    implements ConditionalExpression {

  private ConditionalExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ConditionalExpression ternary0(
      ConditionalOrExpression condition,
      ExpressionCode trueExpression, ExpressionCode falseExpression) {
    return build0(
        ImmutableCodeElement.builder()
            .withCodeElement(condition)
            .withQuestionMark()
            .withCodeElement(trueExpression)
            .withColon()
            .withCodeElement(falseExpression)
            .build()
    );
  }
  
  private static ConditionalExpression build0(ImmutableCodeElement delegate) {
    return new ConditionalExpressionImpl(delegate);
  }

}
