/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.element.NewLine;

final class MethodInvocationImpl
    extends AbstractDefaultStatementExpression
    implements
    MethodInvocation {

  private MethodInvocationImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static MethodInvocation invoke0(
      Callee callee, String methodName) {
    return invoke1(callee, methodName, Arguments.empty());
  }

  static MethodInvocation invoke0(
      Callee callee, String methodName, Argument... args) {
    return invoke1(callee, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(
      Callee callee, String methodName, Iterable<? extends Argument> args) {
    return invoke1(callee, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(
      Callee callee, TypeWitness witness, String methodName) {
    return invoke1(callee, witness, methodName, Arguments.empty());
  }

  static MethodInvocation invoke0(
      Callee callee, TypeWitness witness, String methodName, Argument... args) {
    return invoke1(callee, witness, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(
      Callee callee, TypeWitness witness, String methodName, Iterable<? extends Argument> args) {
    return invoke1(callee, witness, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(String methodName) {
    return invoke1(methodName, Arguments.empty());
  }

  static MethodInvocation invoke0(String methodName, Argument... args) {
    return invoke1(methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(String methodName, Iterable<? extends Argument> args) {
    return invoke1(methodName, Arguments.of(args));
  }

  private static MethodInvocation build0(ImmutableCodeElement delegate) {
    return new MethodInvocationImpl(delegate);
  }

  private static MethodInvocation invoke1(Callee callee, String methodName, Arguments args) {
    return build0(
        ImmutableCodeElement.builder()
            .withCodeElement(callee)
            .withIndentIfNecessary()
            .withSpaceOff()
            .withDot()
            .with(methodName)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  private static MethodInvocation invoke1(
      Callee callee, TypeWitness witness, String methodName, Arguments args) {
    return build0(
        ImmutableCodeElement.builder()
            .withCodeElement(callee)
            .withIndentIfNecessary()
            .withSpaceOff()
            .withDot()
            .withSpaceOff()
            .withCodeElement(witness)
            .withWord(methodName)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  static MethodInvocation invoke1(String methodName, Arguments args) {
    return build0(
        ImmutableCodeElement.builder()
            .withIndentIfNecessary()
            .withWord(methodName)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  @Override
  public final MethodInvocation nl() {
    return build0(append(NewLine.nextLine()));
  }

  @Override
  public final FieldAccess id(Identifier id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  public final FieldAccess id(String id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    return this;
  }

  @Override
  protected final Callee selfCallee() {
    return this;
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(MethodInvocation.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    return this;
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    return this;
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    return this;
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}
