/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterable;
import br.com.objectos.comuns.collections.StreamIterator;

final class FormattedStatement extends AbstractCodeElement implements Statement {

  private final ImmutableList<CodeElement> elements;

  private FormattedStatement(ImmutableList<CodeElement> elements) {
    this.elements = elements;
  }

  static FormattedStatement of(StreamIterable<BlockElement> elements) {
    return new FormattedStatement(elements.map(CodeElement.class::cast).toImmutableList());
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    StreamIterator<CodeElement> it = elements.iterator();
    if (it.hasNext()) {
      w.writeCodeElement(it.next());
      while (it.hasNext()) {
        w.nextLine();
        w.writeCodeElement(it.next());
      }
    }
    return w;
  }

  @Override
  public final void acceptStatementOrBlockBuilder(StatementOrBlockBuilder builder) {
    builder.withStatement(this);
  }

}