/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.type;

public interface TypeNameVisitor<R, P> {

  R visitArrayTypeName(ArrayTypeName t, P p);

  R visitClassName(ClassName t, P p);

  R visitNoTypeName(NoTypeName t, P p);

  R visitParameterizedTypeName(ParameterizedTypeName t, P p);

  R visitPrimitiveType(PrimitiveTypeName t, P p);

  R visitTypeVariableName(TypeVariableName t, P p);
  
  R visitWildcardTypeNameExtends(WildcardTypeName.Extends t, P p);
  
  R visitWildcardTypeNameSuper(WildcardTypeName.Super t, P p);
  
  R visitWildcardTypeNameUnbounded(WildcardTypeName.Unbounded t, P p);

}