/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.type;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

public class TypeNames {

  private TypeNames() {}

  // ArrayTypeName

  public static ArrayTypeName a(ArrayTypeName type) {
    checkNotNull(type, "type == null");
    return ArrayTypeName.ofUnchecked(type);
  }

  public static ArrayTypeName a(ClassNameOrParameterizedTypeName type) {
    checkNotNull(type, "type == null");
    return ArrayTypeName.ofUnchecked(type);
  }

  public static ArrayTypeName a(PrimitiveTypeName type) {
    checkNotNull(type, "type == null");
    return ArrayTypeName.ofUnchecked(type);
  }

  public static ArrayTypeName a(TypeVariableName type) {
    checkNotNull(type, "type == null");
    return ArrayTypeName.ofUnchecked(type);
  }

  // ClassName

  public static ClassName cn(Class<?> type) {
    checkNotNull(type, "type == null");
    return ClassName.ofUnchecked(type);
  }
  
  // NoTypeName

  public static NoTypeName _void() {
    return NoTypeName._void();
  }

  // PrimitiveTypeName

  public static PrimitiveTypeName _boolean() {
    return PrimitiveTypeName.BOOLEAN;
  }

  public static PrimitiveTypeName _byte() {
    return PrimitiveTypeName.BYTE;
  }

  public static PrimitiveTypeName _short() {
    return PrimitiveTypeName.SHORT;
  }

  public static PrimitiveTypeName _int() {
    return PrimitiveTypeName.INT;
  }

  public static PrimitiveTypeName _long() {
    return PrimitiveTypeName.LONG;
  }

  public static PrimitiveTypeName _char() {
    return PrimitiveTypeName.CHAR;
  }

  public static PrimitiveTypeName _float() {
    return PrimitiveTypeName.FLOAT;
  }

  public static PrimitiveTypeName _double() {
    return PrimitiveTypeName.DOUBLE;
  }

  // TypeVariableName

  public static TypeVariableName tvn(String name) {
    return TypeVariableName.named(name);
  }
  
  // WildcardTypeName

  public static WildcardTypeName wildcard() {
    return WildcardTypeName.UNBOUNDED;
  }

  public static WildcardTypeName wildcardExtends(ReferenceTypeName bound) {
    checkNotNull(bound, "bound == null");
    return WildcardTypeName.extendsUnchecked(bound);
  }

  public static WildcardTypeName wildcardSuper(ReferenceTypeName bound) {
    checkNotNull(bound, "bound == null");
    return WildcardTypeName.superUnchecked(bound);
  }

}
