/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.Section;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.StreamIterator;

abstract class AnnotationValue
extends AbstractCodeElement {
    private static final AnnotationValue EMPTY = new Empty();

    AnnotationValue() {
    }

    public static AnnotationValue empty() {
        return EMPTY;
    }

    public AnnotationValue addClass(ClassName type) {
        throw new IllegalArgumentException("Member cannot have different types");
    }

    public AnnotationValue addString(String string) {
        throw new IllegalArgumentException("Member cannot have different types");
    }

    private static class Empty
    extends AnnotationValue {
        private Empty() {
        }

        @Override
        public final AnnotationValue addClass(ClassName type) {
            return new ClassSingle(type);
        }

        @Override
        public final AnnotationValue addString(String string) {
            return new StringSingle(string);
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w;
        }
    }

    private static class StringArray
    extends AnnotationValue {
        private final GrowableList<String> value = GrowableList.newList();

        StringArray(String v0, String v1) {
            this.value.add((Object)v0);
            this.value.add((Object)v1);
        }

        @Override
        public final AnnotationValue addString(String string) {
            this.value.add((Object)string);
            return this;
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            w.write('{').beginSection(Section.ARRAY_LITERAL);
            StreamIterator iterator = this.value.iterator();
            if (iterator.hasNext()) {
                w.nextLine().writePreIndentation().writeStringLiteral((String)iterator.next());
                while (iterator.hasNext()) {
                    w.write(',').nextLine().writePreIndentation().writeStringLiteral((String)iterator.next());
                }
            }
            if (!this.value.isEmpty()) {
                w.nextLine();
            }
            return w.endSection().write('}');
        }
    }

    private static class StringSingle
    extends AnnotationValue {
        private final String value;

        StringSingle(String value) {
            this.value = value;
        }

        @Override
        public final AnnotationValue addString(String string) {
            return new StringArray(this.value, string);
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            throw new UnsupportedOperationException("Implement me");
        }
    }

    private static class ClassSingle
    extends AnnotationValue {
        private final ClassName value;

        ClassSingle(ClassName value) {
            this.value = value;
        }

        @Override
        public final CodeWriter acceptCodeWriter(CodeWriter w) {
            return w.writeTypeName(this.value).write(".class");
        }
    }
}

